/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.MarkupText;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.mantis.MantisBuildAction;
import hudson.plugins.mantis.MantisIssue;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.Utility;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MantisLinkAnnotator
extends ChangeLogAnnotator {
    private static final Pattern ISSUE_PATTERN = Pattern.compile("\\bissue #?(\\d+)\\b", 2);

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        MantisProjectProperty mpp = (MantisProjectProperty)((AbstractProject)build.getParent()).getProperty(MantisProjectProperty.class);
        if (mpp == null || mpp.getSite() == null) {
            return;
        }
        MantisBuildAction action = (MantisBuildAction)build.getAction(MantisBuildAction.class);
        String url = mpp.getSite().getUrl().toExternalForm();
        for (MarkupText.SubText st : text.findTokens(ISSUE_PATTERN)) {
            Long id = Long.valueOf(st.group(1));
            String newUrl = Util.encodeRFC2396((String)(url + "view.php?id=$1"));
            MantisIssue issue = null;
            if (action != null) {
                issue = action.getIssue(id);
            }
            if (issue == null) {
                st.surroundWith("<a href='" + newUrl + "'>", "</a>");
                continue;
            }
            String summary = Utility.escape(issue.getSummary());
            st.surroundWith(String.format("<a href='%s' tooltip='%s'>", newUrl, summary), "</a>");
        }
    }
}

