/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisIssue;
import hudson.plugins.mantis.MantisProjectProperty;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;
import org.mantisbt.connect.IMCSession;
import org.mantisbt.connect.MCException;
import org.mantisbt.connect.axis.MCSession;
import org.mantisbt.connect.model.IIssue;
import org.mantisbt.connect.model.INote;
import org.mantisbt.connect.model.Note;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MantisSite {
    private static final String END_POINT = "api/soap/mantisconnect.php";
    private URL url;
    private final String userName;
    private final String password;

    public static MantisSite get(AbstractProject<?, ?> p) {
        MantisSite site;
        MantisProjectProperty mpp = (MantisProjectProperty)p.getProperty(MantisProjectProperty.class);
        if (mpp != null && (site = mpp.getSite()) != null) {
            return site;
        }
        MantisSite[] sites = MantisProjectProperty.DESCRIPTOR.getSites();
        if (sites.length == 1) {
            return sites[0];
        }
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.url.toExternalForm();
    }

    @DataBoundConstructor
    public MantisSite(URL url, String userName, String password) {
        if (!url.toExternalForm().endsWith("/")) {
            try {
                this.url = new URL(url.toExternalForm() + '/');
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            this.url = url;
        }
        this.userName = Util.fixEmpty((String)userName);
        this.password = Util.fixEmpty((String)password);
    }

    public boolean isConnect() {
        try {
            IMCSession session = this.createSession();
            session.getConfigString("default_language");
        }
        catch (MantisHandlingException e) {
            return false;
        }
        catch (MCException e) {
            return false;
        }
        return true;
    }

    public MantisIssue getIssue(Long id) throws MantisHandlingException {
        IIssue issue;
        IMCSession session = this.createSession();
        try {
            issue = session.getIssue(id.longValue());
        }
        catch (MCException e) {
            throw new MantisHandlingException(e);
        }
        if (issue == null) {
            return null;
        }
        return new MantisIssue(id, issue.getSummary());
    }

    public void addNote(Long id, String text, boolean keepNotePrivate) throws MantisHandlingException {
        IMCSession session = this.createSession();
        Note note = new Note();
        note.setPrivate(keepNotePrivate);
        note.setText(text);
        try {
            session.addNote(id.longValue(), (INote)note);
        }
        catch (MCException e) {
            throw new MantisHandlingException(e);
        }
    }

    private IMCSession createSession() throws MantisHandlingException {
        MCSession session;
        URL mcUrl;
        if (this.userName == null || this.password == null) {
            throw new MantisHandlingException("user name or password is null.");
        }
        try {
            mcUrl = new URL(this.url.toExternalForm() + END_POINT);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
        try {
            session = new MCSession(mcUrl, this.userName, this.password);
        }
        catch (MCException e) {
            throw new MantisHandlingException(e);
        }
        return session;
    }
}

