/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.mantis.MantisBuildAction;
import hudson.plugins.mantis.MantisCarryOverAction;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisIssue;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.MantisUpdaterProperty;
import hudson.plugins.mantis.Messages;
import hudson.scm.ChangeLogSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Updater {
    private static final Pattern ISSUE_PATTERN = Pattern.compile("(?<=\\bissue #?)(\\d+)(?>\\b)", 2);
    private final MantisUpdaterProperty property;

    Updater(MantisUpdaterProperty property) {
        this.property = property;
    }

    boolean perform(AbstractBuild<?, ?> build, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        MantisSite site = MantisSite.get(build.getProject());
        if (site == null) {
            logger.println(Messages.Updater_NoMantisSite());
            build.setResult(Result.FAILURE);
            return true;
        }
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl == null) {
            logger.println(Messages.Updater_NoHudsonUrl());
            build.setResult(Result.FAILURE);
            return true;
        }
        Set<Long> ids = this.findIssueIdsRecursive(build);
        if (ids.isEmpty()) {
            return true;
        }
        boolean noUpdate = build.getResult().isWorseThan(Result.SUCCESS);
        if (noUpdate) {
            build.addAction((Action)new MantisCarryOverAction(ids.toArray(new Long[ids.size()])));
        }
        ArrayList<MantisIssue> issues = new ArrayList<MantisIssue>();
        try {
            for (Long id : ids) {
                MantisIssue issue = site.getIssue(id);
                if (issue == null) continue;
                if (!noUpdate) {
                    String prjName = build.getProject().getName();
                    int prjNumber = build.getNumber();
                    String url = Util.encode((String)(rootUrl + build.getUrl()));
                    String text = Messages.Updater_IssueIntegrated(prjName, prjNumber, url);
                    site.addNote(id, text, this.property.isKeepNotePrivate());
                    logger.println(Messages.Updater_Updating(id));
                }
                issues.add(issue);
            }
        }
        catch (MantisHandlingException e) {
            logger.println(Messages.Updater_FailedToAddNote());
            build.setResult(Result.FAILURE);
            return true;
        }
        build.getActions().add(new MantisBuildAction(issues.toArray(new MantisIssue[issues.size()])));
        return true;
    }

    private Set<Long> findIssueIdsRecursive(AbstractBuild<?, ?> build) {
        MantisCarryOverAction action;
        HashSet<Long> ids = new HashSet<Long>();
        Run prev = build.getPreviousBuild();
        if (prev != null && (action = (MantisCarryOverAction)prev.getAction(MantisCarryOverAction.class)) != null) {
            ids.addAll(Arrays.asList(action.getIDs()));
        }
        ids.addAll(this.findIssuesIds(build));
        for (AbstractBuild.DependencyChange depc : build.getDependencyChanges((AbstractBuild)build.getPreviousBuild()).values()) {
            for (AbstractBuild b : depc.getBuilds()) {
                ids.addAll(this.findIssuesIds(b));
            }
        }
        return ids;
    }

    private Set<Long> findIssuesIds(AbstractBuild<?, ?> build) {
        HashSet<Long> ids = new HashSet<Long>();
        for (ChangeLogSet.Entry change : build.getChangeSet()) {
            Matcher matcher = ISSUE_PATTERN.matcher(change.getMsg());
            while (matcher.find()) {
                ids.add(Long.valueOf(matcher.group()));
            }
        }
        return ids;
    }
}

