/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Extension;
import hudson.MarkupText;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.mantis.MantisBuildAction;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.Utility;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class MantisLinkAnnotator
extends ChangeLogAnnotator {
    private static final Logger LOGGER = Logger.getLogger(MantisLinkAnnotator.class.getName());

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        MantisProjectProperty mpp = (MantisProjectProperty)((AbstractProject)build.getParent()).getProperty(MantisProjectProperty.class);
        if (mpp == null || mpp.getSite() == null) {
            return;
        }
        if (!mpp.isLinkEnabled()) {
            return;
        }
        MantisBuildAction action = (MantisBuildAction)build.getAction(MantisBuildAction.class);
        String url = mpp.getSite().getUrl().toExternalForm();
        ArrayList<MantisIssue> notSavedIssues = new ArrayList<MantisIssue>();
        Pattern pattern = this.findRegexPattern(action, mpp);
        for (MarkupText.SubText st : text.findTokens(pattern)) {
            MantisIssue issue;
            int id;
            try {
                id = Integer.valueOf(st.group(1));
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, Messages.MantisLinkAnnotator_IllegalMantisId((Object)st.group(1)));
                continue;
            }
            if (action != null) {
                issue = action.getIssue(id);
            } else {
                issue = this.getIssue(build, id);
                if (issue != null) {
                    notSavedIssues.add(issue);
                }
            }
            String newUrl = Util.encode((String)(url + "view.php?id=$1"));
            if (issue == null) {
                LOGGER.log(Level.WARNING, Messages.MantisLinkAnnotator_FailedToGetMantisIssue((Object)id));
                st.surroundWith(String.format("<a href='%s'>", newUrl), "</a>");
                continue;
            }
            String summary = Utility.escape((String)issue.getSummary());
            st.surroundWith(String.format("<a href='%s' tooltip='%s'>", newUrl, summary), "</a>");
        }
        if (!notSavedIssues.isEmpty()) {
            this.saveIssues(build, pattern, notSavedIssues);
        }
    }

    private Pattern findRegexPattern(MantisBuildAction action, MantisProjectProperty mpp) {
        Pattern pattern = null;
        if (action != null) {
            pattern = action.getPattern();
        }
        if (pattern == null) {
            pattern = mpp.getRegexpPattern();
        }
        return pattern;
    }

    private void saveIssues(AbstractBuild<?, ?> build, Pattern pattern, List<MantisIssue> issues) {
        MantisBuildAction action = new MantisBuildAction(pattern, issues.toArray(new MantisIssue[0]));
        build.getActions().add(action);
        try {
            build.save();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, Messages.MantisLinkAnnotator_FailedToSave(), e);
        }
    }

    private MantisIssue getIssue(AbstractBuild<?, ?> build, int id) {
        MantisSite site = MantisSite.get((AbstractProject)build.getProject());
        MantisIssue issue = null;
        try {
            issue = site.getIssue(id);
        }
        catch (MantisHandlingException e) {
            // empty catch block
        }
        return issue;
    }
}

