/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.Messages;
import hudson.util.CopyOnWriteList;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MantisProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private final String siteName;

    @DataBoundConstructor
    public MantisProjectProperty(String siteName) {
        MantisSite[] sites;
        String name = siteName;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            name = sites[0].getName();
        }
        this.siteName = name;
    }

    public MantisSite getSite() {
        MantisSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (MantisSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private final CopyOnWriteList<MantisSite> sites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(MantisProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return Messages.MantisProjectProperty_DisplayName();
        }

        public MantisSite[] getSites() {
            return (MantisSite[])this.sites.toArray((Object[])new MantisSite[0]);
        }

        public JobProperty<?> newInstance(StaplerRequest req) throws Descriptor.FormException {
            MantisProjectProperty mpp = (MantisProjectProperty)((Object)req.bindParameters(MantisProjectProperty.class, "mantis."));
            if (mpp.siteName == null) {
                mpp = null;
            }
            return mpp;
        }

        public boolean configure(StaplerRequest req) {
            this.sites.replaceBy((Collection)req.bindParametersToList(MantisSite.class, "mantis."));
            this.save();
            return true;
        }

        public void doUrlCheck(StaplerRequest req, StaplerResponse res) throws IOException, ServletException {
            new FormFieldValidator.URLCheck(req, res){

                protected void check() throws IOException, ServletException {
                    String value = Util.fixEmptyAndTrim((String)this.request.getParameter("value"));
                    if (value == null) {
                        this.error(Messages.MantisProjectProperty_MantisUrlMandatory());
                        return;
                    }
                    try {
                        this.open(new URL(value));
                    }
                    catch (IOException e) {
                        this.error(Messages.MantisProjectProperty_NotOpenUrl());
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void doLoginCheck(final StaplerRequest req, StaplerResponse res) throws IOException, ServletException {
            new FormFieldValidator(req, res, false){

                protected void check() throws IOException, ServletException {
                    String pass;
                    String url = Util.fixEmptyAndTrim((String)req.getParameter("url"));
                    if (url == null) {
                        this.ok();
                        return;
                    }
                    String user = req.getParameter("user");
                    MantisSite site = new MantisSite(new URL(url), user, pass = req.getParameter("pass"));
                    if (!site.isConnect()) {
                        this.error(Messages.MantisProjectProperty_UnableToLogin());
                        return;
                    }
                    this.ok();
                }
            }.process();
        }
    }
}

