/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.plugins.mantis.model.MantisNote;
import hudson.plugins.mantis.model.MantisViewState;
import hudson.plugins.mantis.soap.MantisConnectLocator;
import hudson.plugins.mantis.soap.MantisConnectPortType;
import hudson.plugins.mantis.soap.MantisSession;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MantisSite {
    private static final String END_POINT = "api/soap/mantisconnect.php";
    private URL url;
    private final String userName;
    private final String password;

    public static MantisSite get(AbstractProject<?, ?> p) {
        MantisSite site;
        MantisProjectProperty mpp = (MantisProjectProperty)p.getProperty(MantisProjectProperty.class);
        if (mpp != null && (site = mpp.getSite()) != null) {
            return site;
        }
        MantisSite[] sites = MantisProjectProperty.DESCRIPTOR.getSites();
        if (sites.length == 1) {
            return sites[0];
        }
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.url.toExternalForm();
    }

    @DataBoundConstructor
    public MantisSite(URL url, String userName, String password) {
        if (!url.toExternalForm().endsWith("/")) {
            try {
                this.url = new URL(url.toExternalForm() + '/');
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            this.url = url;
        }
        this.userName = Util.fixEmpty((String)userName);
        this.password = Util.fixEmpty((String)password);
    }

    public boolean isConnect() {
        try {
            MantisSession session = this.createSession();
            session.getConfigString("default_language");
        }
        catch (MantisHandlingException e) {
            return false;
        }
        return true;
    }

    public MantisIssue getIssue(Long id) throws MantisHandlingException {
        MantisSession session = this.createSession();
        MantisIssue issue = session.getIssue(id);
        if (issue == null) {
            return null;
        }
        return issue;
    }

    public void addNote(Long id, String text, boolean keepNotePrivate) throws MantisHandlingException {
        MantisViewState viewState = keepNotePrivate ? MantisViewState.PRIVATE : MantisViewState.PUBLIC;
        MantisNote note = new MantisNote(text, viewState);
        MantisSession session = this.createSession();
        session.addNote(id, note);
    }

    private MantisSession createSession() throws MantisHandlingException {
        MantisConnectPortType portType;
        URL endpoint;
        if (this.userName == null || this.password == null) {
            throw new MantisHandlingException("user name or password is null.");
        }
        try {
            endpoint = new URL(this.url, END_POINT);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
        try {
            MantisConnectLocator locator = new MantisConnectLocator();
            portType = locator.getMantisConnectPort(endpoint);
        }
        catch (ServiceException e) {
            throw new MantisHandlingException(e);
        }
        return new MantisSession(this, portType);
    }
}

