/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.soap;

import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.plugins.mantis.model.MantisNote;
import hudson.plugins.mantis.soap.IssueData;
import hudson.plugins.mantis.soap.IssueNoteData;
import hudson.plugins.mantis.soap.MantisConnectPortType;
import hudson.plugins.mantis.soap.ObjectRef;
import java.math.BigInteger;
import java.rmi.RemoteException;

public final class MantisSession {
    private final MantisConnectPortType portType;
    private final MantisSite site;

    public MantisSession(MantisSite site, MantisConnectPortType portType) {
        this.site = site;
        this.portType = portType;
    }

    public String getConfigString(String key) throws MantisHandlingException {
        String configString;
        try {
            configString = this.portType.mc_config_get_string(this.site.getUserName(), this.site.getPassword(), key);
        }
        catch (RemoteException e) {
            throw new MantisHandlingException(e);
        }
        return configString;
    }

    public MantisIssue getIssue(Long id) throws MantisHandlingException {
        IssueData data;
        try {
            data = this.portType.mc_issue_get(this.site.getUserName(), this.site.getPassword(), BigInteger.valueOf(id));
        }
        catch (RemoteException e) {
            throw new MantisHandlingException(e);
        }
        return new MantisIssue(new Long(id), data.getSummary());
    }

    public void addNote(Long id, MantisNote note) throws MantisHandlingException {
        IssueNoteData data = new IssueNoteData();
        data.setText(note.getText());
        data.setView_state(new ObjectRef(BigInteger.valueOf(note.getViewState().getCode()), null));
        try {
            this.portType.mc_issue_note_add(this.site.getUserName(), this.site.getPassword(), BigInteger.valueOf(id), data);
        }
        catch (RemoteException e) {
            throw new MantisHandlingException(e);
        }
    }
}

