/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Util;
import java.io.PrintStream;

public final class Utility {
    private Utility() {
    }

    public static String escape(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        block7: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    if (i < len - 1 && str.charAt(i + 1) == '#') {
                        buf.append(c);
                        continue block7;
                    }
                    buf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&#039;");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String join(Long[] longs, String separator) {
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        for (Long l : longs) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(String.valueOf(l));
        }
        return sb.toString();
    }

    public static Long[] tokenize(String str, String delimiter) {
        if (str == null || delimiter == null) {
            return new Long[0];
        }
        String[] s = Util.tokenize((String)str, (String)delimiter);
        Long[] l = new Long[s.length];
        for (int i = 0; i < s.length; ++i) {
            l[i] = Long.valueOf(s[i]);
        }
        return l;
    }

    public static void log(PrintStream logger, String message, Object ... args) {
        StringBuffer buf = new StringBuffer();
        buf.append("[MANTIS] ").append(message);
        logger.printf(buf.toString(), args);
        logger.println();
    }
}

