/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.plugins.mantis.model.MantisNote;
import hudson.plugins.mantis.model.MantisViewState;
import hudson.plugins.mantis.soap.MantisSession;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MantisSite {
    private URL url;
    private final String userName;
    private final String password;
    private final String basicUserName;
    private final String basicPassword;
    private static final Logger LOGGER = Logger.getLogger(MantisSite.class.getName());

    public static MantisSite get(AbstractProject<?, ?> p) {
        MantisSite site;
        MantisProjectProperty mpp = (MantisProjectProperty)p.getProperty(MantisProjectProperty.class);
        if (mpp != null && (site = mpp.getSite()) != null) {
            return site;
        }
        MantisSite[] sites = MantisProjectProperty.DESCRIPTOR.getSites();
        if (sites.length == 1) {
            return sites[0];
        }
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.url.toExternalForm();
    }

    public String getBasicUserName() {
        return this.basicUserName;
    }

    public String getBasicPassword() {
        return this.basicPassword;
    }

    @DataBoundConstructor
    public MantisSite(URL url, String userName, String password, String basicUserName, String basicPassword) {
        if (!url.toExternalForm().endsWith("/")) {
            try {
                this.url = new URL(url.toExternalForm() + '/');
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            this.url = url;
        }
        this.userName = Util.fixEmptyAndTrim((String)userName);
        this.password = Util.fixEmptyAndTrim((String)password);
        this.basicUserName = Util.fixEmptyAndTrim((String)basicUserName);
        this.basicPassword = Util.fixEmptyAndTrim((String)basicPassword);
    }

    public boolean isConnect() {
        String urlString = this.url.toExternalForm();
        try {
            MantisSession session = this.createSession();
            session.getConfigString("default_language");
        }
        catch (MantisHandlingException e) {
            LOGGER.log(Level.WARNING, Messages.MantisSite_FailedToConnectToMantis(urlString, e.getMessage()));
            return false;
        }
        LOGGER.log(Level.INFO, Messages.MantisSite_SucceedInConnectingToMantis(urlString));
        return true;
    }

    public MantisIssue getIssue(Long id) throws MantisHandlingException {
        MantisSession session = this.createSession();
        return session.getIssue(id);
    }

    public void updateIssue(Long id, String text, boolean keepNotePrivate) throws MantisHandlingException {
        MantisViewState viewState = keepNotePrivate ? MantisViewState.PRIVATE : MantisViewState.PUBLIC;
        MantisNote note = new MantisNote(text, viewState);
        MantisSession session = this.createSession();
        session.addNote(id, note);
    }

    private MantisSession createSession() throws MantisHandlingException {
        return MantisSession.create(this);
    }
}

