/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.Utility;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MantisProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final String ISSUE_ID_STRING = "%ID%";
    private static final String DEFAULT_PATTERN = "issue #?%ID%";
    private final String siteName;
    private final String pattern;
    private final Pattern regExp;
    private final boolean linkEnabled;

    @DataBoundConstructor
    public MantisProjectProperty(String siteName, String pattern, boolean linkEnabled) {
        MantisSite[] sites;
        String name = siteName;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            name = sites[0].getName();
        }
        this.siteName = Util.fixEmptyAndTrim((String)name);
        this.pattern = Util.fixEmptyAndTrim((String)pattern);
        this.regExp = this.createRegExp(this.pattern);
        this.linkEnabled = linkEnabled;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Pattern getRegExp() {
        return this.regExp;
    }

    public boolean isLinkEnabled() {
        return this.linkEnabled;
    }

    public MantisSite getSite() {
        MantisSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (MantisSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    private Pattern createRegExp(String p) {
        StringBuffer buf = new StringBuffer();
        buf.append("(?<=");
        if (p != null) {
            buf.append(Utility.escapeRegExp((String)p));
        } else {
            buf.append(DEFAULT_PATTERN);
        }
        buf.append(")");
        String regExp = buf.toString().replace(ISSUE_ID_STRING, ")(\\d+)(?=");
        return Pattern.compile(regExp);
    }

    static /* synthetic */ String access$000(MantisProjectProperty x0) {
        return x0.siteName;
    }
}

