/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.soap;

import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.plugins.mantis.model.MantisNote;
import hudson.plugins.mantis.soap.IssueData;
import hudson.plugins.mantis.soap.IssueNoteData;
import hudson.plugins.mantis.soap.MantisConnectLocator;
import hudson.plugins.mantis.soap.MantisConnectPortType;
import hudson.plugins.mantis.soap.ObjectRef;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisProperties;
import org.apache.axis.client.Stub;

public final class MantisSession {
    private static final String END_POINT = "api/soap/mantisconnect.php";
    private final MantisConnectPortType portType;
    private final MantisSite site;

    public static MantisSession create(MantisSite site) throws MantisHandlingException {
        MantisConnectPortType portType;
        try {
            URL endpoint = new URL(site.getUrl(), END_POINT);
            MantisConnectLocator locator = new MantisConnectLocator();
            portType = locator.getMantisConnectPort(endpoint);
            if (site.getBasicUserName() != null && site.getBasicPassword() != null) {
                ((Stub)portType).setUsername(site.getBasicUserName());
                ((Stub)portType).setPassword(site.getBasicPassword());
            }
            AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"org.apache.axis.components.net.SunFakeTrustSocketFactory");
        }
        catch (ServiceException e) {
            throw new MantisHandlingException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new MantisHandlingException((Throwable)e);
        }
        return new MantisSession(site, portType);
    }

    private MantisSession(MantisSite site, MantisConnectPortType portType) {
        this.site = site;
        this.portType = portType;
    }

    public String getConfigString(String key) throws MantisHandlingException {
        String configString;
        try {
            configString = this.portType.mc_config_get_string(this.site.getUserName(), this.site.getPassword(), key);
        }
        catch (RemoteException e) {
            throw new MantisHandlingException((Throwable)e);
        }
        return configString;
    }

    public MantisIssue getIssue(int id) throws MantisHandlingException {
        IssueData data;
        try {
            data = this.portType.mc_issue_get(this.site.getUserName(), this.site.getPassword(), BigInteger.valueOf(id));
        }
        catch (RemoteException e) {
            throw new MantisHandlingException((Throwable)e);
        }
        return new MantisIssue(id, data.getSummary());
    }

    public void addNote(int id, MantisNote note) throws MantisHandlingException {
        IssueNoteData data = new IssueNoteData();
        data.setText(note.getText());
        data.setView_state(new ObjectRef(BigInteger.valueOf(note.getViewState().getCode()), null));
        try {
            this.portType.mc_issue_note_add(this.site.getUserName(), this.site.getPassword(), BigInteger.valueOf(id), data);
        }
        catch (RemoteException e) {
            throw new MantisHandlingException((Throwable)e);
        }
    }
}

