/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.Utility;
import hudson.util.CopyOnWriteList;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MantisProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final String ISSUE_ID_STRING = "%ID%";
    private static final String DEFAULT_PATTERN = "issue #?%ID%";
    private final String siteName;
    private final String pattern;
    private final Pattern regExp;
    private final boolean linkEnabled;

    @DataBoundConstructor
    public MantisProjectProperty(String siteName, String pattern, boolean linkEnabled) {
        MantisSite[] sites;
        String name = siteName;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            name = sites[0].getName();
        }
        this.siteName = Util.fixEmptyAndTrim((String)name);
        this.pattern = Util.fixEmptyAndTrim((String)pattern);
        this.regExp = this.createRegExp(this.pattern);
        this.linkEnabled = linkEnabled;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Pattern getRegExp() {
        return this.regExp;
    }

    public boolean isLinkEnabled() {
        return this.linkEnabled;
    }

    public MantisSite getSite() {
        MantisSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (MantisSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    private Pattern createRegExp(String p) {
        StringBuffer buf = new StringBuffer();
        buf.append("(?<=");
        if (p != null) {
            buf.append(Utility.escapeRegExp(p));
        } else {
            buf.append(DEFAULT_PATTERN);
        }
        buf.append(")");
        String regExp = buf.toString().replace(ISSUE_ID_STRING, ")(\\d+)(?=");
        return Pattern.compile(regExp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private final CopyOnWriteList<MantisSite> sites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(MantisProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return Messages.MantisProjectProperty_DisplayName();
        }

        public MantisSite[] getSites() {
            return (MantisSite[])this.sites.toArray((Object[])new MantisSite[0]);
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            MantisProjectProperty mpp = (MantisProjectProperty)((Object)req.bindParameters(MantisProjectProperty.class, "mantis."));
            if (mpp.siteName == null) {
                mpp = null;
            }
            return mpp;
        }

        public boolean configure(StaplerRequest req) {
            this.sites.replaceBy((Collection)req.bindParametersToList(MantisSite.class, "mantis."));
            this.save();
            return true;
        }

        public void doLoginCheck(final StaplerRequest req, StaplerResponse res) throws IOException, ServletException {
            new FormFieldValidator(req, res, false){

                protected void check() throws IOException, ServletException {
                    String bPass;
                    String bUser;
                    String pass;
                    String url = Util.fixEmptyAndTrim((String)req.getParameter("url"));
                    if (url == null) {
                        this.error(Messages.MantisProjectProperty_MantisUrlMandatory());
                        return;
                    }
                    String user = Util.fixEmptyAndTrim((String)req.getParameter("user"));
                    MantisSite site = new MantisSite(new URL(url), user, pass = Util.fixEmptyAndTrim((String)req.getParameter("pass")), bUser = Util.fixEmptyAndTrim((String)req.getParameter("buser")), bPass = Util.fixEmptyAndTrim((String)req.getParameter("bpass")));
                    if (!site.isConnect()) {
                        this.error(Messages.MantisProjectProperty_UnableToLogin());
                        return;
                    }
                    this.ok();
                }
            }.process();
        }

        public void doPatternCheck(final StaplerRequest req, StaplerResponse res) throws IOException, ServletException {
            new FormFieldValidator(req, res, false){

                protected void check() throws IOException, ServletException {
                    String pattern = Util.fixEmptyAndTrim((String)req.getParameter("pattern"));
                    if (pattern == null) {
                        this.ok();
                        return;
                    }
                    if (pattern.indexOf(MantisProjectProperty.ISSUE_ID_STRING) == -1) {
                        this.error(Messages.MantisProjectProperty_InvalidPattern(MantisProjectProperty.ISSUE_ID_STRING));
                        return;
                    }
                    this.ok();
                }
            }.process();
        }
    }
}

