/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.mantis.MantisBuildAction;
import hudson.plugins.mantis.MantisCarryOverAction;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisIssueUpdater;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.Utility;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.scm.ChangeLogSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Updater {
    private final MantisIssueUpdater property;

    Updater(MantisIssueUpdater property) {
        this.property = property;
    }

    boolean perform(AbstractBuild<?, ?> build, BuildListener listener) {
        boolean update;
        PrintStream logger = listener.getLogger();
        MantisSite site = MantisSite.get(build.getProject());
        if (site == null) {
            Utility.log(logger, Messages.Updater_NoMantisSite());
            build.setResult(Result.FAILURE);
            return true;
        }
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl == null) {
            Utility.log(logger, Messages.Updater_NoHudsonUrl());
            build.setResult(Result.FAILURE);
            return true;
        }
        int[] ids = this.findIssueIdsRecursive(build);
        if (ids.length == 0) {
            Utility.log(logger, Messages.Updater_NoIssuesFound());
            return true;
        }
        boolean bl = update = !build.getResult().isWorseThan(Result.UNSTABLE);
        if (!update) {
            Utility.log(logger, Messages.Updater_KeepMantisIssueIdsForNextBuild());
            build.addAction((Action)new MantisCarryOverAction(ids));
        }
        ArrayList<MantisIssue> issues = new ArrayList<MantisIssue>();
        for (int id : ids) {
            try {
                MantisIssue issue = site.getIssue(id);
                if (update) {
                    String text = this.createUpdateText(build, rootUrl);
                    site.updateIssue(id, text, this.property.isKeepNotePrivate());
                    Utility.log(logger, Messages.Updater_Updating(id));
                }
                issues.add(issue);
            }
            catch (MantisHandlingException e) {
                Utility.log(logger, Messages.Updater_FailedToAddNote(id, e.getMessage()));
                build.setResult(Result.FAILURE);
            }
        }
        build.getActions().add(new MantisBuildAction(issues.toArray(new MantisIssue[issues.size()])));
        return true;
    }

    private String createUpdateText(AbstractBuild<?, ?> build, String rootUrl) {
        String prjName = build.getProject().getName();
        int prjNumber = build.getNumber();
        String url = Util.encode((String)(rootUrl + build.getUrl()));
        String text = Messages.Updater_IssueIntegrated(prjName, prjNumber, url);
        return text;
    }

    private int[] findIssueIdsRecursive(AbstractBuild<?, ?> build) {
        MantisCarryOverAction action;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Run prev = build.getPreviousBuild();
        if (prev != null && (action = (MantisCarryOverAction)prev.getAction(MantisCarryOverAction.class)) != null) {
            for (int id : action.getIDs()) {
                ids.add(id);
            }
        }
        ids.addAll(this.findIssuesIds(build));
        for (AbstractBuild.DependencyChange depc : build.getDependencyChanges((AbstractBuild)build.getPreviousBuild()).values()) {
            for (AbstractBuild b : depc.getBuilds()) {
                ids.addAll(this.findIssuesIds(b));
            }
        }
        int[] array = new int[ids.size()];
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            array[i] = (Integer)ids.get(i);
        }
        return array;
    }

    private List<Integer> findIssuesIds(AbstractBuild<?, ?> build) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        MantisProjectProperty mpp = (MantisProjectProperty)((AbstractProject)build.getParent()).getProperty(MantisProjectProperty.class);
        if (mpp == null || mpp.getSite() == null) {
            return ids;
        }
        Pattern pattern = mpp.getRegExp();
        for (ChangeLogSet.Entry change : build.getChangeSet()) {
            Matcher matcher = pattern.matcher(change.getMsg());
            while (matcher.find()) {
                ids.add(Integer.valueOf(matcher.group()));
            }
        }
        return ids;
    }
}

