// CHECKSTYLE:OFF

package hudson.plugins.mantis;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = new ResourceBundleHolder(Messages.class);

    /**
     * Unable to login with the user name and password.
     * 
     */
    public static String MantisProjectProperty_UnableToLogin() {
        return holder.format("MantisProjectProperty_UnableToLogin");
    }

    /**
     * Unable to login with the user name and password.
     * 
     */
    public static Localizable _MantisProjectProperty_UnableToLogin() {
        return new Localizable(holder, "MantisProjectProperty_UnableToLogin");
    }

    /**
     * This build seems to be broken. Keep Mantis issue Ids for the next build.
     * 
     */
    public static String Updater_KeepMantisIssueIdsForNextBuild() {
        return holder.format("Updater.KeepMantisIssueIdsForNextBuild");
    }

    /**
     * This build seems to be broken. Keep Mantis issue Ids for the next build.
     * 
     */
    public static Localizable _Updater_KeepMantisIssueIdsForNextBuild() {
        return new Localizable(holder, "Updater.KeepMantisIssueIdsForNextBuild");
    }

    /**
     * Integrated in {0}:{1}  ( See {2} ).
     * 
     */
    public static String Updater_IssueIntegrated(Object arg1, Object arg2, Object arg3) {
        return holder.format("Updater_IssueIntegrated", arg1, arg2, arg3);
    }

    /**
     * Integrated in {0}:{1}  ( See {2} ).
     * 
     */
    public static Localizable _Updater_IssueIntegrated(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "Updater_IssueIntegrated", arg1, arg2, arg3);
    }

    /**
     * Mantis URL is a mandatory field.
     * 
     */
    public static String MantisProjectProperty_MantisUrlMandatory() {
        return holder.format("MantisProjectProperty_MantisUrlMandatory");
    }

    /**
     * Mantis URL is a mandatory field.
     * 
     */
    public static Localizable _MantisProjectProperty_MantisUrlMandatory() {
        return new Localizable(holder, "MantisProjectProperty_MantisUrlMandatory");
    }

    /**
     * Updated relevant Mantis issues
     * 
     */
    public static String MantisIssueUpdater_DisplayName() {
        return holder.format("MantisIssueUpdater_DisplayName");
    }

    /**
     * Updated relevant Mantis issues
     * 
     */
    public static Localizable _MantisIssueUpdater_DisplayName() {
        return new Localizable(holder, "MantisIssueUpdater_DisplayName");
    }

    /**
     * Updating Mantis issue #{0}
     * 
     */
    public static String Updater_Updating(Object arg1) {
        return holder.format("Updater.Updating", arg1);
    }

    /**
     * Updating Mantis issue #{0}
     * 
     */
    public static Localizable _Updater_Updating(Object arg1) {
        return new Localizable(holder, "Updater.Updating", arg1);
    }

    /**
     * Mantis issues
     * 
     */
    public static String MantiBuildAction_Displayname() {
        return holder.format("MantiBuildAction_Displayname");
    }

    /**
     * Mantis issues
     * 
     */
    public static Localizable _MantiBuildAction_Displayname() {
        return new Localizable(holder, "MantiBuildAction_Displayname");
    }

    /**
     * Failed to add note to Mantis issue #{0} (cause: {1}).
     * 
     */
    public static String Updater_FailedToAddNote(Object arg1, Object arg2) {
        return holder.format("Updater.FailedToAddNote", arg1, arg2);
    }

    /**
     * Failed to add note to Mantis issue #{0} (cause: {1}).
     * 
     */
    public static Localizable _Updater_FailedToAddNote(Object arg1, Object arg2) {
        return new Localizable(holder, "Updater.FailedToAddNote", arg1, arg2);
    }

    /**
     * Failed to connect {0} (cause: {1}).
     * 
     */
    public static String MantisSite_FailedToConnectToMantis(Object arg1, Object arg2) {
        return holder.format("MantisSite.FailedToConnectToMantis", arg1, arg2);
    }

    /**
     * Failed to connect {0} (cause: {1}).
     * 
     */
    public static Localizable _MantisSite_FailedToConnectToMantis(Object arg1, Object arg2) {
        return new Localizable(holder, "MantisSite.FailedToConnectToMantis", arg1, arg2);
    }

    /**
     * No issues have been found in the changelog.
     * 
     */
    public static String Updater_NoIssuesFound() {
        return holder.format("Updater.NoIssuesFound");
    }

    /**
     * No issues have been found in the changelog.
     * 
     */
    public static Localizable _Updater_NoIssuesFound() {
        return new Localizable(holder, "Updater.NoIssuesFound");
    }

    /**
     * Associated Mantis Website
     * 
     */
    public static String MantisProjectProperty_DisplayName() {
        return holder.format("MantisProjectProperty_DisplayName");
    }

    /**
     * Associated Mantis Website
     * 
     */
    public static Localizable _MantisProjectProperty_DisplayName() {
        return new Localizable(holder, "MantisProjectProperty_DisplayName");
    }

    /**
     * Succeed in connecting to {0}.
     * 
     */
    public static String MantisSite_SucceedInConnectingToMantis(Object arg1) {
        return holder.format("MantisSite.SucceedInConnectingToMantis", arg1);
    }

    /**
     * Succeed in connecting to {0}.
     * 
     */
    public static Localizable _MantisSite_SucceedInConnectingToMantis(Object arg1) {
        return new Localizable(holder, "MantisSite.SucceedInConnectingToMantis", arg1);
    }

    /**
     * No Mantis site is configured for this project. This must be a project configuration error
     * 
     */
    public static String Updater_NoMantisSite() {
        return holder.format("Updater.NoMantisSite");
    }

    /**
     * No Mantis site is configured for this project. This must be a project configuration error
     * 
     */
    public static Localizable _Updater_NoMantisSite() {
        return new Localizable(holder, "Updater.NoMantisSite");
    }

    /**
     * Failed to get Mantis issue #{0}.
     * 
     */
    public static String MantisLinkAnnotator_FailedToGetMantisIssue(Object arg1) {
        return holder.format("MantisLinkAnnotator.FailedToGetMantisIssue", arg1);
    }

    /**
     * Failed to get Mantis issue #{0}.
     * 
     */
    public static Localizable _MantisLinkAnnotator_FailedToGetMantisIssue(Object arg1) {
        return new Localizable(holder, "MantisLinkAnnotator.FailedToGetMantisIssue", arg1);
    }

    /**
     * Hudson URL is not configured yet. Go to system configuration to set this value
     * 
     */
    public static String Updater_NoHudsonUrl() {
        return holder.format("Updater.NoHudsonUrl");
    }

    /**
     * Hudson URL is not configured yet. Go to system configuration to set this value
     * 
     */
    public static Localizable _Updater_NoHudsonUrl() {
        return new Localizable(holder, "Updater.NoHudsonUrl");
    }

    /**
     * {0} not found. Specify the pattern such as [ISSUE: {0}].
     * 
     */
    public static String MantisProjectProperty_InvalidPattern(Object arg1) {
        return holder.format("MantisProjectProperty_InvalidPattern", arg1);
    }

    /**
     * {0} not found. Specify the pattern such as [ISSUE: {0}].
     * 
     */
    public static Localizable _MantisProjectProperty_InvalidPattern(Object arg1) {
        return new Localizable(holder, "MantisProjectProperty_InvalidPattern", arg1);
    }

}
