/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.MarkupText;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.mantis.MantisBuildAction;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.Utility;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MantisLinkAnnotator
extends ChangeLogAnnotator {
    private static final Logger LOGGER = Logger.getLogger(MantisLinkAnnotator.class.getName());

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        MantisProjectProperty mpp = (MantisProjectProperty)((AbstractProject)build.getParent()).getProperty(MantisProjectProperty.class);
        if (mpp == null || mpp.getSite() == null) {
            return;
        }
        if (!mpp.isLinkEnabled()) {
            return;
        }
        MantisBuildAction action = (MantisBuildAction)build.getAction(MantisBuildAction.class);
        String url = mpp.getSite().getUrl().toExternalForm();
        Pattern pattern = mpp.getRegExp();
        for (MarkupText.SubText st : text.findTokens(pattern)) {
            int id = Integer.valueOf(st.group(1));
            String newUrl = Util.encodeRFC2396((String)(url + "view.php?id=$1"));
            MantisIssue issue = null;
            issue = action != null ? action.getIssue(id) : this.getIssue(build, id);
            if (issue == null) {
                LOGGER.log(Level.WARNING, Messages.MantisLinkAnnotator_FailedToGetMantisIssue(id));
                st.surroundWith("<a href='" + newUrl + "'>", "</a>");
                continue;
            }
            String summary = Utility.escape(issue.getSummary());
            st.surroundWith(String.format("<a href='%s' tooltip='%s'>", newUrl, summary), "</a>");
        }
    }

    private MantisIssue getIssue(AbstractBuild<?, ?> build, int id) {
        MantisIssue issue = null;
        MantisSite site = MantisSite.get(build.getProject());
        try {
            issue = site.getIssue(id);
        }
        catch (MantisHandlingException e) {
            // empty catch block
        }
        return issue;
    }
}

