/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.changeset;

import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.plugins.mantis.changeset.CVSChangeSet;
import hudson.plugins.mantis.changeset.ChangeSet;
import hudson.plugins.mantis.changeset.CompatibleChangeSet;
import hudson.plugins.mantis.changeset.DefaultChangeSet;
import hudson.plugins.mantis.changeset.GitChangeSet;
import hudson.plugins.mantis.changeset.MercurialChangeSet;
import hudson.plugins.mantis.changeset.SubversionChangeSet;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.ChangeLogSet;
import hudson.scm.SubversionChangeLogSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangeSetFactory {
    private ChangeSetFactory() {
    }

    public static ChangeSet newInstance(int id) {
        return new CompatibleChangeSet(id);
    }

    public static ChangeSet newInstance(int id, AbstractBuild<?, ?> build, ChangeLogSet.Entry entry) {
        if (build == null || entry == null) {
            throw new IllegalArgumentException();
        }
        if (entry instanceof SubversionChangeLogSet.LogEntry) {
            return new SubversionChangeSet(id, build, (SubversionChangeLogSet.LogEntry)entry);
        }
        if (entry instanceof CVSChangeLogSet.CVSChangeLog) {
            return new CVSChangeSet(id, build, (CVSChangeLogSet.CVSChangeLog)entry);
        }
        if (Hudson.getInstance().getPlugin("mercurial") != null && entry instanceof hudson.plugins.mercurial.MercurialChangeSet) {
            return new MercurialChangeSet(id, build, (hudson.plugins.mercurial.MercurialChangeSet)entry);
        }
        if (Hudson.getInstance().getPlugin("git") != null && entry instanceof hudson.plugins.git.GitChangeSet) {
            return new GitChangeSet(id, build, (hudson.plugins.git.GitChangeSet)entry);
        }
        return new DefaultChangeSet(id, build, entry);
    }
}

