/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.changeset;

import hudson.model.AbstractBuild;
import hudson.plugins.mantis.changeset.AbstractChangeSet;
import hudson.plugins.mantis.changeset.Messages;
import hudson.plugins.mantis.changeset.SubversionChangeSet;
import hudson.scm.ChangeLogSet;
import hudson.scm.SubversionChangeLogSet;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubversionChangeSet
extends AbstractChangeSet {
    private static final long serialVersionUID = 1L;

    public SubversionChangeSet(int id, AbstractBuild<?, ?> build, SubversionChangeLogSet.LogEntry entry) {
        super(id, build, (ChangeLogSet.Entry)entry);
    }

    public String createChangeLog() {
        StringBuilder text = new StringBuilder();
        text.append(Messages.ChangeSet_Revision((Object)this.getRevision(), (Object)this.getChangeSetLink()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_Author((Object)this.getAuthor()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_Log((Object)this.getMsg()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_ChangedPaths_Header());
        text.append(CRLF);
        for (AffectedPath path : this.getAffectedPaths()) {
            text.append(Messages.ChangeSet_ChangedPaths_Path((Object)path.getMark(), (Object)path.getPath()));
            text.append(CRLF);
        }
        text.append(CRLF);
        return text.toString();
    }

    protected String getRevision() {
        return String.valueOf(((SubversionChangeLogSet.LogEntry)this.entry).getRevision());
    }

    private List<AffectedPath> getAffectedPaths() {
        ArrayList<AffectedPath> paths = new ArrayList<AffectedPath>();
        for (SubversionChangeLogSet.Path path : ((SubversionChangeLogSet.LogEntry)this.entry).getPaths()) {
            paths.add(new AffectedPath(path.getEditType(), path.getValue()));
        }
        return paths;
    }
}

