/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.mantis.MantisBuildAction;
import hudson.plugins.mantis.MantisCarryOverAction;
import hudson.plugins.mantis.MantisCarryOverChangeSetAction;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisIssueUpdater;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.Utility;
import hudson.plugins.mantis.changeset.ChangeSet;
import hudson.plugins.mantis.changeset.ChangeSetFactory;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.scm.ChangeLogSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Updater {
    private static final String CRLF = System.getProperty("line.separator");
    private final MantisIssueUpdater property;
    private static final Logger LOGGER = Logger.getLogger(Updater.class.getName());

    Updater(MantisIssueUpdater property) {
        this.property = property;
    }

    boolean perform(AbstractBuild<?, ?> build, BuildListener listener) {
        boolean update;
        PrintStream logger = listener.getLogger();
        MantisSite site = MantisSite.get(build.getProject());
        if (site == null) {
            Utility.log(logger, Messages.Updater_NoMantisSite());
            build.setResult(Result.FAILURE);
            return true;
        }
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl == null) {
            Utility.log(logger, Messages.Updater_NoHudsonUrl());
            build.setResult(Result.FAILURE);
            return true;
        }
        List<ChangeSet> chnageSets = this.findChangeSets(build);
        if (chnageSets.isEmpty()) {
            Utility.log(logger, Messages.Updater_NoIssuesFound());
            return true;
        }
        boolean bl = update = !build.getResult().isWorseThan(Result.UNSTABLE);
        if (!update) {
            Utility.log(logger, Messages.Updater_KeepMantisIssueIdsForNextBuild());
            build.addAction((Action)new MantisCarryOverChangeSetAction(chnageSets));
        }
        ArrayList<MantisIssue> issues = new ArrayList<MantisIssue>();
        for (ChangeSet changeSet : chnageSets) {
            try {
                MantisIssue issue = site.getIssue(changeSet.getId());
                if (update) {
                    String text = this.createUpdateText(build, changeSet, rootUrl);
                    site.updateIssue(changeSet.getId(), text, this.property.isKeepNotePrivate());
                    Utility.log(logger, Messages.Updater_Updating(changeSet.getId()));
                }
                issues.add(issue);
            }
            catch (MantisHandlingException e) {
                Utility.log(logger, Messages.Updater_FailedToAddNote(changeSet, e.getMessage()));
                LOGGER.log(Level.WARNING, Messages.Updater_FailedToAddNote_StarckTrace(changeSet), e);
            }
        }
        build.getActions().add(new MantisBuildAction(issues.toArray(new MantisIssue[issues.size()])));
        return true;
    }

    private String createUpdateText(AbstractBuild<?, ?> build, ChangeSet changeSet, String rootUrl) {
        String prjName = build.getProject().getName();
        int prjNumber = build.getNumber();
        String url = rootUrl + build.getUrl();
        StringBuilder text = new StringBuilder();
        text.append(Messages.Updater_IssueIntegrated(prjName, prjNumber, url));
        text.append(CRLF).append(CRLF);
        if (this.property.isRecordChangelog()) {
            text.append(changeSet.createChangeLog());
        }
        return text.toString();
    }

    private List<ChangeSet> findChangeSets(AbstractBuild<?, ?> build) {
        ArrayList<ChangeSet> chnageSets = new ArrayList<ChangeSet>();
        Run prev = build.getPreviousBuild();
        if (prev != null) {
            MantisCarryOverChangeSetAction changeSetAction;
            MantisCarryOverAction action = (MantisCarryOverAction)prev.getAction(MantisCarryOverAction.class);
            if (action != null) {
                for (int id : action.getIDs()) {
                    chnageSets.add(ChangeSetFactory.newInstance(id));
                }
            }
            if ((changeSetAction = (MantisCarryOverChangeSetAction)prev.getAction(MantisCarryOverChangeSetAction.class)) != null) {
                for (ChangeSet changeSet : changeSetAction.getChangeSets()) {
                    chnageSets.add(changeSet);
                }
            }
        }
        chnageSets.addAll(this.findChangeSetsFromSCM(build));
        for (AbstractBuild.DependencyChange depc : build.getDependencyChanges((AbstractBuild)build.getPreviousBuild()).values()) {
            for (AbstractBuild b : depc.getBuilds()) {
                chnageSets.addAll(this.findChangeSetsFromSCM(b));
            }
        }
        return chnageSets;
    }

    private List<ChangeSet> findChangeSetsFromSCM(AbstractBuild<?, ?> build) {
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        MantisProjectProperty mpp = (MantisProjectProperty)((AbstractProject)build.getParent()).getProperty(MantisProjectProperty.class);
        if (mpp == null || mpp.getSite() == null) {
            return changeSets;
        }
        Pattern pattern = mpp.getRegExp();
        for (ChangeLogSet.Entry change : build.getChangeSet()) {
            Matcher matcher = pattern.matcher(change.getMsg());
            while (matcher.find()) {
                int id = Integer.parseInt(matcher.group());
                changeSets.add(ChangeSetFactory.newInstance(id, build, change));
            }
        }
        return changeSets;
    }
}

