/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.changeset;

import hudson.model.AbstractBuild;
import hudson.plugins.mantis.changeset.AbstractChangeSet;
import hudson.plugins.mantis.changeset.Messages;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSChangeSet
extends AbstractChangeSet {
    private static final long serialVersionUID = 1L;

    public CVSChangeSet(int id, AbstractBuild<?, ?> build, CVSChangeLogSet.CVSChangeLog entry) {
        super(id, build, (ChangeLogSet.Entry)entry);
    }

    @Override
    public String createChangeLog() {
        StringBuilder text = new StringBuilder();
        text.append(Messages.ChangeSet_Author(this.getAuthor()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_Log(this.getMsg()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_ChangedPaths_Header());
        text.append(CRLF);
        for (AffectedPath path : this.getAffectedPaths()) {
            text.append(Messages.ChangeSet_ChangedPaths_CVS_Path(path.getMark(), path.getPath(), path.getRevision(), path.getDiffLink()));
            text.append(CRLF);
        }
        text.append(CRLF);
        return text.toString();
    }

    @Override
    protected String getChangeSetLink() {
        return "";
    }

    private List<AffectedPath> getAffectedPaths() {
        ArrayList<AffectedPath> paths = new ArrayList<AffectedPath>();
        CVSRepositoryBrowser browser = (CVSRepositoryBrowser)this.getRepositoryBrowser();
        for (CVSChangeLogSet.File file : ((CVSChangeLogSet.CVSChangeLog)this.entry).getFiles()) {
            paths.add(new AffectedPath(file, browser));
        }
        return paths;
    }

    private static class AffectedPath {
        private static final String MARK_ADD = "A";
        private static final String MARK_DELETE = "D";
        private static final String MARK_EDIT = "M";
        private static final String MARK_UNKNOWN = " ";
        private final CVSChangeLogSet.File file;
        private final CVSRepositoryBrowser browser;

        public AffectedPath(CVSChangeLogSet.File file, CVSRepositoryBrowser browser) {
            this.file = file;
            this.browser = browser;
        }

        public String getMark() {
            EditType type = this.file.getEditType();
            if (EditType.ADD.equals(type)) {
                return MARK_ADD;
            }
            if (EditType.DELETE.equals(type)) {
                return MARK_DELETE;
            }
            if (EditType.EDIT.equals(type)) {
                return MARK_EDIT;
            }
            return MARK_UNKNOWN;
        }

        public String getPath() {
            return this.file.getFullName();
        }

        public String getRevision() {
            return this.file.getPrevrevision();
        }

        public String getDiffLink() {
            if (this.browser == null) {
                return "";
            }
            URL link = null;
            try {
                link = this.browser.getDiffLink(this.file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return link == null ? "" : link.toExternalForm();
        }
    }
}

