/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.changeset;

import hudson.model.AbstractBuild;
import hudson.plugins.mantis.changeset.AbstractChangeSet;
import hudson.plugins.mantis.changeset.MercurialChangeSet;
import hudson.plugins.mantis.changeset.Messages;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialChangeSet
extends AbstractChangeSet<hudson.plugins.mercurial.MercurialChangeSet> {
    private static final long serialVersionUID = 1L;

    public MercurialChangeSet(int id, AbstractBuild<?, ?> build, hudson.plugins.mercurial.MercurialChangeSet entry) {
        super(id, build, (ChangeLogSet.Entry)entry);
    }

    public String createChangeLog() {
        StringBuilder text = new StringBuilder();
        text.append(Messages.ChangeSet_Revision((Object)this.getRevision(), (Object)this.getChangeSetLink()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_Author((Object)this.getAuthor()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_Log((Object)this.getMsg()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_ChangedPaths_Header());
        text.append(CRLF);
        for (AffectedPath path : this.getAffectedPaths()) {
            text.append(Messages.ChangeSet_ChangedPaths_Path((Object)path.getMark(), (Object)path.getPath()));
            text.append(CRLF);
        }
        text.append(CRLF);
        return text.toString();
    }

    protected String getRevision() {
        return String.valueOf(((hudson.plugins.mercurial.MercurialChangeSet)this.entry).getRev()) + ":" + ((hudson.plugins.mercurial.MercurialChangeSet)this.entry).getShortNode();
    }

    private List<AffectedPath> getAffectedPaths() {
        ArrayList<AffectedPath> affectedPaths = new ArrayList<AffectedPath>();
        for (EditType type : new EditType[]{EditType.ADD, EditType.EDIT, EditType.DELETE}) {
            affectedPaths.addAll(this.getAffectedPathsByEditType(type));
        }
        return affectedPaths;
    }

    private List<AffectedPath> getAffectedPathsByEditType(EditType type) {
        ArrayList<AffectedPath> affectedPaths = new ArrayList<AffectedPath>();
        List paths = ((hudson.plugins.mercurial.MercurialChangeSet)this.entry).getPaths(type);
        if (paths == null) {
            return affectedPaths;
        }
        for (String path : paths) {
            affectedPaths.add(new AffectedPath(type, path));
        }
        return affectedPaths;
    }
}

