// CHECKSTYLE:OFF

package hudson.plugins.mantis;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Failed to save build.xml.
     * 
     */
    public static String MantisLinkAnnotator_FailedToSave() {
        return holder.format("MantisLinkAnnotator.FailedToSave");
    }

    /**
     * Failed to save build.xml.
     * 
     */
    public static Localizable _MantisLinkAnnotator_FailedToSave() {
        return new Localizable(holder, "MantisLinkAnnotator.FailedToSave");
    }

    /**
     *  1.1.X
     * 
     */
    public static String MantisSite_MantisVersion_V110() {
        return holder.format("MantisSite.MantisVersion.V110");
    }

    /**
     *  1.1.X
     * 
     */
    public static Localizable _MantisSite_MantisVersion_V110() {
        return new Localizable(holder, "MantisSite.MantisVersion.V110");
    }

    /**
     * Updated relevant Mantis issues
     * 
     */
    public static String MantisIssueUpdater_DisplayName() {
        return holder.format("MantisIssueUpdater.DisplayName");
    }

    /**
     * Updated relevant Mantis issues
     * 
     */
    public static Localizable _MantisIssueUpdater_DisplayName() {
        return new Localizable(holder, "MantisIssueUpdater.DisplayName");
    }

    /**
     * Mantis id "{0}" doesn't seem to be an integer.
     * 
     */
    public static String MantisLinkAnnotator_IllegalMantisId(Object arg1) {
        return holder.format("MantisLinkAnnotator.IllegalMantisId", arg1);
    }

    /**
     * Mantis id "{0}" doesn't seem to be an integer.
     * 
     */
    public static Localizable _MantisLinkAnnotator_IllegalMantisId(Object arg1) {
        return new Localizable(holder, "MantisLinkAnnotator.IllegalMantisId", arg1);
    }

    /**
     * Integrated in {0}:{1}  ( See {2} ).
     * 
     */
    public static String Updater_IssueIntegrated(Object arg1, Object arg2, Object arg3) {
        return holder.format("Updater.IssueIntegrated", arg1, arg2, arg3);
    }

    /**
     * Integrated in {0}:{1}  ( See {2} ).
     * 
     */
    public static Localizable _Updater_IssueIntegrated(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "Updater.IssueIntegrated", arg1, arg2, arg3);
    }

    /**
     * Hudson URL is not configured yet. Go to system configuration to set this value
     * 
     */
    public static String Updater_NoHudsonUrl() {
        return holder.format("Updater.NoHudsonUrl");
    }

    /**
     * Hudson URL is not configured yet. Go to system configuration to set this value
     * 
     */
    public static Localizable _Updater_NoHudsonUrl() {
        return new Localizable(holder, "Updater.NoHudsonUrl");
    }

    /**
     * Specified Mantis seems to be {0}.
     * 
     */
    public static String MantisSite_DetectedVersion(Object arg1) {
        return holder.format("MantisSite.DetectedVersion", arg1);
    }

    /**
     * Specified Mantis seems to be {0}.
     * 
     */
    public static Localizable _MantisSite_DetectedVersion(Object arg1) {
        return new Localizable(holder, "MantisSite.DetectedVersion", arg1);
    }

    /**
     * {0} {1}
     * 
     */
    public static String Updater_ChangeSet_Files_File(Object arg1, Object arg2) {
        return holder.format("Updater.ChangeSet.Files.File", arg1, arg2);
    }

    /**
     * {0} {1}
     * 
     */
    public static Localizable _Updater_ChangeSet_Files_File(Object arg1, Object arg2) {
        return new Localizable(holder, "Updater.ChangeSet.Files.File", arg1, arg2);
    }

    /**
     * Failed to connect {0} (cause: {1}).
     * 
     */
    public static String MantisSite_FailedToConnectToMantis(Object arg1, Object arg2) {
        return holder.format("MantisSite.FailedToConnectToMantis", arg1, arg2);
    }

    /**
     * Failed to connect {0} (cause: {1}).
     * 
     */
    public static Localizable _MantisSite_FailedToConnectToMantis(Object arg1, Object arg2) {
        return new Localizable(holder, "MantisSite.FailedToConnectToMantis", arg1, arg2);
    }

    /**
     *  1.2.X
     * 
     */
    public static String MantisSite_MantisVersion_V120() {
        return holder.format("MantisSite.MantisVersion.V120");
    }

    /**
     *  1.2.X
     * 
     */
    public static Localizable _MantisSite_MantisVersion_V120() {
        return new Localizable(holder, "MantisSite.MantisVersion.V120");
    }

    /**
     * This build seems to be broken. Keep Mantis issue Ids for the next build.
     * 
     */
    public static String Updater_KeepMantisIssueIdsForNextBuild() {
        return holder.format("Updater.KeepMantisIssueIdsForNextBuild");
    }

    /**
     * This build seems to be broken. Keep Mantis issue Ids for the next build.
     * 
     */
    public static Localizable _Updater_KeepMantisIssueIdsForNextBuild() {
        return new Localizable(holder, "Updater.KeepMantisIssueIdsForNextBuild");
    }

    /**
     * Associated Mantis Website
     * 
     */
    public static String MantisProjectProperty_DisplayName() {
        return holder.format("MantisProjectProperty.DisplayName");
    }

    /**
     * Associated Mantis Website
     * 
     */
    public static Localizable _MantisProjectProperty_DisplayName() {
        return new Localizable(holder, "MantisProjectProperty.DisplayName");
    }

    /**
     * Failed to add note to Mantis issue #{0} (cause: {1}).
     * 
     */
    public static String Updater_FailedToAddNote(Object arg1, Object arg2) {
        return holder.format("Updater.FailedToAddNote", arg1, arg2);
    }

    /**
     * Failed to add note to Mantis issue #{0} (cause: {1}).
     * 
     */
    public static Localizable _Updater_FailedToAddNote(Object arg1, Object arg2) {
        return new Localizable(holder, "Updater.FailedToAddNote", arg1, arg2);
    }

    /**
     * [Log] 
     * {0}
     * 
     */
    public static String Updater_ChangeSet_Log(Object arg1) {
        return holder.format("Updater.ChangeSet.Log", arg1);
    }

    /**
     * [Log] 
     * {0}
     * 
     */
    public static Localizable _Updater_ChangeSet_Log(Object arg1) {
        return new Localizable(holder, "Updater.ChangeSet.Log", arg1);
    }

    /**
     * No Mantis site is configured for this project. This must be a project configuration error
     * 
     */
    public static String Updater_NoMantisSite() {
        return holder.format("Updater.NoMantisSite");
    }

    /**
     * No Mantis site is configured for this project. This must be a project configuration error
     * 
     */
    public static Localizable _Updater_NoMantisSite() {
        return new Localizable(holder, "Updater.NoMantisSite");
    }

    /**
     * [Revision] {0} {1}
     * 
     */
    public static String Updater_ChangeSet_Revision(Object arg1, Object arg2) {
        return holder.format("Updater.ChangeSet.Revision", arg1, arg2);
    }

    /**
     * [Revision] {0} {1}
     * 
     */
    public static Localizable _Updater_ChangeSet_Revision(Object arg1, Object arg2) {
        return new Localizable(holder, "Updater.ChangeSet.Revision", arg1, arg2);
    }

    /**
     * Mantis issues
     * 
     */
    public static String MantiBuildAction_Displayname() {
        return holder.format("MantiBuildAction.Displayname");
    }

    /**
     * Mantis issues
     * 
     */
    public static Localizable _MantiBuildAction_Displayname() {
        return new Localizable(holder, "MantiBuildAction.Displayname");
    }

    /**
     * Failed to get Mantis issue #{0}.
     * 
     */
    public static String MantisLinkAnnotator_FailedToGetMantisIssue(Object arg1) {
        return holder.format("MantisLinkAnnotator.FailedToGetMantisIssue", arg1);
    }

    /**
     * Failed to get Mantis issue #{0}.
     * 
     */
    public static Localizable _MantisLinkAnnotator_FailedToGetMantisIssue(Object arg1) {
        return new Localizable(holder, "MantisLinkAnnotator.FailedToGetMantisIssue", arg1);
    }

    /**
     * Succeed in connecting to {0}.
     * 
     */
    public static String MantisSite_SucceedInConnectingToMantis(Object arg1) {
        return holder.format("MantisSite.SucceedInConnectingToMantis", arg1);
    }

    /**
     * Succeed in connecting to {0}.
     * 
     */
    public static Localizable _MantisSite_SucceedInConnectingToMantis(Object arg1) {
        return new Localizable(holder, "MantisSite.SucceedInConnectingToMantis", arg1);
    }

    /**
     * Failed to add note to Mantis issue #{0}.
     * 
     */
    public static String Updater_FailedToAddNote_StarckTrace(Object arg1) {
        return holder.format("Updater.FailedToAddNote.StarckTrace", arg1);
    }

    /**
     * Failed to add note to Mantis issue #{0}.
     * 
     */
    public static Localizable _Updater_FailedToAddNote_StarckTrace(Object arg1) {
        return new Localizable(holder, "Updater.FailedToAddNote.StarckTrace", arg1);
    }

    /**
     * {0} not found. Specify the pattern such as [ISSUE: {0}].
     * 
     */
    public static String MantisProjectProperty_InvalidPattern(Object arg1) {
        return holder.format("MantisProjectProperty.InvalidPattern", arg1);
    }

    /**
     * {0} not found. Specify the pattern such as [ISSUE: {0}].
     * 
     */
    public static Localizable _MantisProjectProperty_InvalidPattern(Object arg1) {
        return new Localizable(holder, "MantisProjectProperty.InvalidPattern", arg1);
    }

    /**
     * Updating Mantis issue #{0}
     * 
     */
    public static String Updater_Updating(Object arg1) {
        return holder.format("Updater.Updating", arg1);
    }

    /**
     * Updating Mantis issue #{0}
     * 
     */
    public static Localizable _Updater_Updating(Object arg1) {
        return new Localizable(holder, "Updater.Updating", arg1);
    }

    /**
     * Unable to login with the user name and password.
     * 
     */
    public static String MantisProjectProperty_UnableToLogin() {
        return holder.format("MantisProjectProperty.UnableToLogin");
    }

    /**
     * Unable to login with the user name and password.
     * 
     */
    public static Localizable _MantisProjectProperty_UnableToLogin() {
        return new Localizable(holder, "MantisProjectProperty.UnableToLogin");
    }

    /**
     * No issues have been found in the changelog.
     * 
     */
    public static String Updater_NoIssuesFound() {
        return holder.format("Updater.NoIssuesFound");
    }

    /**
     * No issues have been found in the changelog.
     * 
     */
    public static Localizable _Updater_NoIssuesFound() {
        return new Localizable(holder, "Updater.NoIssuesFound");
    }

    /**
     * Mantis id {0} doesn't seem to be an integer.
     * 
     */
    public static String Updater_IllegalMantisId(Object arg1) {
        return holder.format("Updater.IllegalMantisId", arg1);
    }

    /**
     * Mantis id {0} doesn't seem to be an integer.
     * 
     */
    public static Localizable _Updater_IllegalMantisId(Object arg1) {
        return new Localizable(holder, "Updater.IllegalMantisId", arg1);
    }

    /**
     * [Author] {0}
     * 
     */
    public static String Updater_ChangeSet_Author(Object arg1) {
        return holder.format("Updater.ChangeSet.Author", arg1);
    }

    /**
     * [Author] {0}
     * 
     */
    public static Localizable _Updater_ChangeSet_Author(Object arg1) {
        return new Localizable(holder, "Updater.ChangeSet.Author", arg1);
    }

    /**
     * [Files]
     * 
     */
    public static String Updater_ChangeSet_Files_Header() {
        return holder.format("Updater.ChangeSet.Files.Header");
    }

    /**
     * [Files]
     * 
     */
    public static Localizable _Updater_ChangeSet_Files_Header() {
        return new Localizable(holder, "Updater.ChangeSet.Files.Header");
    }

    /**
     * Mantis URL is a mandatory field.
     * 
     */
    public static String MantisProjectProperty_MantisUrlMandatory() {
        return holder.format("MantisProjectProperty.MantisUrlMandatory");
    }

    /**
     * Mantis URL is a mandatory field.
     * 
     */
    public static Localizable _MantisProjectProperty_MantisUrlMandatory() {
        return new Localizable(holder, "MantisProjectProperty.MantisUrlMandatory");
    }

}
