/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.changeset;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.plugins.mantis.changeset.ChangeSet;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChangeSet<T extends ChangeLogSet.Entry>
implements ChangeSet,
Serializable {
    protected int id;
    protected AbstractBuild<?, ?> build;
    protected T entry;

    public AbstractChangeSet(int id, AbstractBuild<?, ?> build, T entry) {
        this.id = id;
        this.build = build;
        this.entry = entry;
    }

    public int getId() {
        return this.id;
    }

    public abstract String createChangeLog();

    protected RepositoryBrowser<T> getRepositoryBrowser() {
        if (this.build == null || this.build.getProject() == null) {
            return null;
        }
        SCM scm = this.build.getProject().getScm();
        return scm.getBrowser();
    }

    protected String getChangeSetLink() {
        RepositoryBrowser browser = this.getRepositoryBrowser();
        if (browser == null) {
            return "";
        }
        String link = "";
        try {
            URL url = browser.getChangeSetLink(this.entry);
            if (url != null) {
                link = url.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return link;
    }

    protected String getAuthor() {
        User user = this.entry.getAuthor();
        return user == null ? "-" : user.getId();
    }

    protected String getMsg() {
        return this.entry == null ? "-" : this.entry.getMsg();
    }
}

