/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.changeset;

import hudson.model.AbstractBuild;
import hudson.plugins.mantis.changeset.AbstractChangeSet;
import hudson.plugins.mantis.changeset.CVSChangeSet;
import hudson.plugins.mantis.changeset.Messages;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.ChangeLogSet;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSChangeSet
extends AbstractChangeSet<CVSChangeLogSet.CVSChangeLog> {
    private static final long serialVersionUID = 1L;

    public CVSChangeSet(int id, AbstractBuild<?, ?> build, CVSChangeLogSet.CVSChangeLog entry) {
        super(id, build, (ChangeLogSet.Entry)entry);
    }

    public String createChangeLog() {
        StringBuilder text = new StringBuilder();
        text.append(Messages.ChangeSet_Author((Object)this.getAuthor()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_Log((Object)this.getMsg()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_ChangedPaths_Header());
        text.append(CRLF);
        for (AffectedPath path : this.getAffectedPaths()) {
            text.append(Messages.ChangeSet_ChangedPaths_CVS_Path((Object)path.getMark(), (Object)path.getRevision(), (Object)path.getPath(), (Object)path.getDiffLink()));
            text.append(CRLF);
        }
        text.append(CRLF);
        return text.toString();
    }

    protected String getChangeSetLink() {
        return "";
    }

    private List<AffectedPath> getAffectedPaths() {
        ArrayList<AffectedPath> paths = new ArrayList<AffectedPath>();
        CVSRepositoryBrowser browser = (CVSRepositoryBrowser)this.getRepositoryBrowser();
        for (CVSChangeLogSet.File file : ((CVSChangeLogSet.CVSChangeLog)this.entry).getFiles()) {
            paths.add(new AffectedPath(file, browser));
        }
        return paths;
    }
}

