/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.soap.mantis120;

import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.plugins.mantis.model.MantisNote;
import hudson.plugins.mantis.soap.AbstractMantisSession;
import hudson.plugins.mantis.soap.mantis120.IssueData;
import hudson.plugins.mantis.soap.mantis120.IssueNoteData;
import hudson.plugins.mantis.soap.mantis120.MantisConnectLocator;
import hudson.plugins.mantis.soap.mantis120.MantisConnectPortType;
import hudson.plugins.mantis.soap.mantis120.ObjectRef;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.Stub;

public final class MantisSessionImpl
extends AbstractMantisSession {
    private final MantisConnectPortType portType;
    private static final Logger LOGGER = Logger.getLogger(MantisSessionImpl.class.getName());

    public MantisSessionImpl(MantisSite site) throws MantisHandlingException {
        LOGGER.info("Mantis version is 1.2.X");
        this.site = site;
        try {
            URL endpoint = new URL(site.getUrl(), "api/soap/mantisconnect.php");
            MantisConnectLocator locator = new MantisConnectLocator();
            EngineConfiguration config = this.createClientConfig();
            locator.setEngineConfiguration(config);
            locator.setEngine((AxisEngine)new AxisClient(config));
            this.portType = locator.getMantisConnectPort(endpoint);
            if (site.getBasicUserName() != null && site.getBasicPassword() != null) {
                ((Stub)this.portType).setUsername(site.getBasicUserName());
                ((Stub)this.portType).setPassword(site.getBasicPassword());
            }
            AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"org.apache.axis.components.net.SunFakeTrustSocketFactory");
        }
        catch (ServiceException e) {
            throw new MantisHandlingException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new MantisHandlingException((Throwable)e);
        }
    }

    public MantisIssue getIssue(int id) throws MantisHandlingException {
        IssueData data;
        try {
            data = this.portType.mc_issue_get(this.site.getUserName(), this.site.getPassword(), BigInteger.valueOf(id));
        }
        catch (RemoteException e) {
            throw new MantisHandlingException((Throwable)e);
        }
        return new MantisIssue(id, data.getSummary());
    }

    public void addNote(int id, MantisNote note) throws MantisHandlingException {
        IssueNoteData data = new IssueNoteData();
        data.setText(note.getText());
        data.setView_state(new ObjectRef(BigInteger.valueOf(note.getViewState().getCode()), null));
        try {
            this.portType.mc_issue_note_add(this.site.getUserName(), this.site.getPassword(), BigInteger.valueOf(id), data);
        }
        catch (RemoteException e) {
            throw new MantisHandlingException((Throwable)e);
        }
    }

    public String getVersion() throws MantisHandlingException {
        String version;
        try {
            version = this.portType.mc_version();
        }
        catch (RemoteException e) {
            throw new MantisHandlingException((Throwable)e);
        }
        return version;
    }
}

