/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.plugins.mantis.model.MantisNote;
import hudson.plugins.mantis.model.MantisViewState;
import hudson.plugins.mantis.soap.MantisSession;
import hudson.plugins.mantis.soap.MantisSessionFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MantisSite {
    private final URL url;
    private MantisVersion version = MantisVersion.V110;
    private final String userName;
    private final String password;
    private final String basicUserName;
    private final String basicPassword;
    private static final Logger LOGGER = Logger.getLogger(MantisSite.class.getName());

    public static MantisSite get(AbstractProject<?, ?> p) {
        MantisSite site;
        MantisProjectProperty mpp = (MantisProjectProperty)p.getProperty(MantisProjectProperty.class);
        if (mpp != null && (site = mpp.getSite()) != null) {
            return site;
        }
        MantisSite[] sites = MantisProjectProperty.DESCRIPTOR.getSites();
        if (sites.length == 1) {
            return sites[0];
        }
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public MantisVersion getVersion() {
        return this.version;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.url.toExternalForm();
    }

    public String getBasicUserName() {
        return this.basicUserName;
    }

    public String getBasicPassword() {
        return this.basicPassword;
    }

    @DataBoundConstructor
    public MantisSite(URL url, String version, String userName, String password, String basicUserName, String basicPassword) {
        if (!url.toExternalForm().endsWith("/")) {
            try {
                this.url = new URL(url.toExternalForm() + '/');
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            this.url = url;
        }
        this.version = MantisVersion.getVersionSafely(version, MantisVersion.V110);
        this.userName = Util.fixEmptyAndTrim((String)userName);
        this.password = Util.fixEmptyAndTrim((String)password);
        this.basicUserName = Util.fixEmptyAndTrim((String)basicUserName);
        this.basicPassword = Util.fixEmptyAndTrim((String)basicPassword);
    }

    public boolean isConnect() {
        String urlString = this.url.toExternalForm();
        try {
            MantisSession session = this.createSession();
            String v = session.getVersion();
            LOGGER.info(Messages.MantisSite_DetectedVersion(v));
        }
        catch (MantisHandlingException e) {
            LOGGER.log(Level.WARNING, Messages.MantisSite_FailedToConnectToMantis(urlString, e.getMessage()));
            return false;
        }
        LOGGER.log(Level.INFO, Messages.MantisSite_SucceedInConnectingToMantis(urlString));
        return true;
    }

    public MantisIssue getIssue(int id) throws MantisHandlingException {
        MantisSession session = this.createSession();
        return session.getIssue(id);
    }

    public void updateIssue(int id, String text, boolean keepNotePrivate) throws MantisHandlingException {
        MantisViewState viewState = keepNotePrivate ? MantisViewState.PRIVATE : MantisViewState.PUBLIC;
        MantisNote note = new MantisNote(text, viewState);
        MantisSession session = this.createSession();
        session.addNote(id, note);
    }

    private MantisSession createSession() throws MantisHandlingException {
        return MantisSessionFactory.getSession(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MantisVersion {
        V110(Messages.MantisSite_MantisVersion_V110()),
        V120(Messages.MantisSite_MantisVersion_V120());

        private final String displayName;

        private MantisVersion(String displayName) {
            this.displayName = displayName;
        }

        public static MantisVersion getVersionSafely(String version, MantisVersion def) {
            MantisVersion ret = def;
            for (MantisVersion v : MantisVersion.values()) {
                if (!v.name().equalsIgnoreCase(version)) continue;
                ret = v;
                break;
            }
            return ret;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

