/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.mavendepsupdate;

import antlr.ANTLRException;
import hudson.FilePath;
import hudson.PluginFirstClassLoader;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TopLevelItem;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.triggers.Trigger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.jvnet.hudson.plugins.mavendepsupdate.MavenDependencyUpdateTrigger;
import org.jvnet.hudson.plugins.mavendepsupdate.MavenUpdateChecker;
import org.jvnet.hudson.plugins.mavendepsupdate.MavenUpdateCheckerResult;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenDependencyUpdateTrigger
extends Trigger<BuildableItem> {
    private static final Logger LOGGER = Logger.getLogger(MavenDependencyUpdateTrigger.class.getName());
    private final boolean checkPlugins;
    public static boolean debug = Boolean.getBoolean("MavenDependencyUpdateTrigger.debug");
    private static final CLIManager mavenCliManager = new CLIManager();

    @DataBoundConstructor
    public MavenDependencyUpdateTrigger(String cron_value, boolean checkPlugins) throws ANTLRException {
        super(cron_value);
        this.checkPlugins = checkPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object projectBuildingRequest = null;
        Node node = ((BuildableItem)this.job).getLastBuiltOn();
        if (node == null) {
            LOGGER.info("no previous build found so skip maven update trigger");
            return;
        }
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            boolean isMaster;
            PluginWrapper pluginWrapper = Hudson.getInstance().getPluginManager().getPlugin("maven-dependency-update-trigger");
            FilePath mavenShadedJar = node.getRootPath().child("maven-dependency-update-trigger-shaded-maven.jar");
            boolean bl = isMaster = node == Hudson.getInstance();
            if (isMaster) {
                mavenShadedJar = node.getRootPath().child("plugins").child("maven-dependency-update-trigger").child("maven-dependency-update-trigger-shaded-maven.jar");
            }
            AbstractProject abstractProject = (AbstractProject)this.job;
            FilePath workspace = node.getWorkspaceFor((TopLevelItem)this.job);
            FilePath moduleRoot = abstractProject.getScm().getModuleRoot(workspace);
            String rootPomPath = moduleRoot.getRemote() + "/" + this.getRootPomPath();
            String localRepoPath = this.getLocalRepo(workspace).toString();
            String projectWorkspace = moduleRoot.getRemote();
            MavenUpdateChecker checker = new MavenUpdateChecker(mavenShadedJar, rootPomPath, localRepoPath, this.checkPlugins, projectWorkspace, isMaster);
            if (isMaster) {
                checker.setClassLoaderParent((PluginFirstClassLoader)pluginWrapper.classLoader);
            }
            VirtualChannel virtualChannel = node.getChannel();
            FilePath alternateSettings = this.getAlternateSettings(virtualChannel);
            checker.setAlternateSettings(alternateSettings);
            FilePath globalSettings = this.getGlobalSettings(virtualChannel);
            checker.setGlobalSettings(globalSettings);
            checker.setUserProperties(this.getUserProperties());
            checker.setActiveProfiles(this.getActiveProfiles());
            LOGGER.info("run MavenUpdateChecker for project " + ((BuildableItem)this.job).getName() + " on node " + node.getDisplayName());
            MavenUpdateCheckerResult mavenUpdateCheckerResult = (MavenUpdateCheckerResult)virtualChannel.call((Callable)checker);
            if (debug) {
                StringBuilder debugLines = new StringBuilder("MavenUpdateChecker for project " + ((BuildableItem)this.job).getName() + " on node " + node.getDisplayName()).append(SystemUtils.LINE_SEPARATOR);
                for (String line : mavenUpdateCheckerResult.getDebugLines()) {
                    debugLines.append(line).append(SystemUtils.LINE_SEPARATOR);
                }
                LOGGER.info(debugLines.toString());
            }
            if (mavenUpdateCheckerResult.getFileUpdatedNames().size() > 0) {
                StringBuilder stringBuilder = new StringBuilder("MavenUpdateChecker for project " + ((BuildableItem)this.job).getName() + " on node " + node.getDisplayName());
                stringBuilder.append(" , snapshotDownloaded so triggering a new build : ").append(SystemUtils.LINE_SEPARATOR);
                for (String fileName : mavenUpdateCheckerResult.getFileUpdatedNames()) {
                    stringBuilder.append(" * " + fileName).append(SystemUtils.LINE_SEPARATOR);
                }
                ((BuildableItem)this.job).scheduleBuild(0, (Cause)new MavenDependencyUpdateTriggerCause(mavenUpdateCheckerResult.getFileUpdatedNames()));
                LOGGER.info(stringBuilder.toString());
            }
        }
        catch (Exception e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    private File getLocalRepo(FilePath workspace) {
        boolean usePrivateRepo = this.usePrivateRepo();
        if (usePrivateRepo) {
            return new File(workspace.getRemote(), ".repository");
        }
        return RepositorySystem.defaultUserLocalRepository;
    }

    private boolean usePrivateRepo() {
        if (this.job instanceof FreeStyleProject) {
            FreeStyleProject fp = (FreeStyleProject)this.job;
            for (Builder b : fp.getBuilders()) {
                if (!(b instanceof Maven) || !((Maven)b).usePrivateRepository) continue;
                return true;
            }
            return false;
        }
        try {
            Method method = ((BuildableItem)this.job).getClass().getMethod("usesPrivateRepository", null);
            Boolean bool = (Boolean)method.invoke((Object)this.job, null);
            return bool;
        }
        catch (SecurityException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        return false;
    }

    private Map<String, MavenProject> getProjectMap(List<MavenProject> projects) {
        LinkedHashMap<String, MavenProject> index = new LinkedHashMap<String, MavenProject>();
        for (MavenProject project : projects) {
            String projectId = ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
            index.put(projectId, project);
        }
        return index;
    }

    private FilePath getAlternateSettings(VirtualChannel virtualChannel) {
        if (this.job instanceof FreeStyleProject) {
            FreeStyleProject fp = (FreeStyleProject)this.job;
            for (Builder b : fp.getBuilders()) {
                if (!(b instanceof Maven)) continue;
                String targets = ((Maven)b).getTargets();
                String[] args = Util.tokenize((String)targets);
                if (args == null) {
                    return null;
                }
                CommandLine cli = this.getCommandLine(args);
                if (cli == null || !cli.hasOption('s')) continue;
                return new FilePath(virtualChannel, cli.getOptionValue('f'));
            }
            return null;
        }
        try {
            Method method = ((BuildableItem)this.job).getClass().getMethod("getAlternateSettings", null);
            String alternateSettings = (String)method.invoke((Object)this.job, null);
            return alternateSettings != null ? new FilePath(virtualChannel, alternateSettings) : null;
        }
        catch (SecurityException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        return null;
    }

    private FilePath getGlobalSettings(VirtualChannel virtualChannel) {
        if (this.job instanceof FreeStyleProject) {
            FreeStyleProject fp = (FreeStyleProject)this.job;
            for (Builder b : fp.getBuilders()) {
                if (!(b instanceof Maven)) continue;
                String targets = ((Maven)b).getTargets();
                String[] args = Util.tokenize((String)targets);
                if (args == null) {
                    return null;
                }
                CommandLine cli = this.getCommandLine(args);
                if (cli == null || !cli.hasOption("gs")) continue;
                return new FilePath(virtualChannel, cli.getOptionValue("gs"));
            }
            return null;
        }
        return null;
    }

    private Properties getUserProperties() throws IOException {
        if (this.job instanceof FreeStyleProject) {
            FreeStyleProject fp = (FreeStyleProject)this.job;
            for (Builder b : fp.getBuilders()) {
                if (!(b instanceof Maven)) continue;
                String properties = ((Maven)b).properties;
                return this.load(properties);
            }
        }
        return new Properties();
    }

    private Properties load(String properties) throws IOException {
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(properties.getBytes()));
        return p;
    }

    private String getRootPomPath() {
        if (this.job instanceof FreeStyleProject) {
            FreeStyleProject fp = (FreeStyleProject)this.job;
            for (Builder b : fp.getBuilders()) {
                if (!(b instanceof Maven)) continue;
                String targets = ((Maven)b).getTargets();
                String[] args = Util.tokenize((String)targets);
                if (args == null) {
                    return null;
                }
                CommandLine cli = this.getCommandLine(args);
                if (cli == null || !cli.hasOption('f')) continue;
                return cli.getOptionValue('f');
            }
            return null;
        }
        try {
            Method method = ((BuildableItem)this.job).getClass().getMethod("getRootPOM", null);
            String rootPom = (String)method.invoke((Object)this.job, null);
            return rootPom;
        }
        catch (SecurityException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        return "pom.xml";
    }

    private List<String> getActiveProfiles() {
        if (this.job instanceof FreeStyleProject) {
            FreeStyleProject fp = (FreeStyleProject)this.job;
            for (Builder b : fp.getBuilders()) {
                if (!(b instanceof Maven)) continue;
                String targets = ((Maven)b).getTargets();
                String[] args = Util.tokenize((String)targets);
                if (args == null) {
                    return null;
                }
                CommandLine cli = this.getCommandLine(args);
                if (cli == null || !cli.hasOption('P')) continue;
                return Arrays.asList(cli.getOptionValues('P'));
            }
            return Collections.emptyList();
        }
        try {
            Method method = ((BuildableItem)this.job).getClass().getMethod("getGoals", null);
            String goals = (String)method.invoke((Object)this.job, null);
            String[] args = Util.tokenize((String)goals);
            if (args == null) {
                return null;
            }
            CommandLine cli = this.getCommandLine(args);
            if (cli != null && cli.hasOption('P')) {
                return Arrays.asList(cli.getOptionValues('P'));
            }
        }
        catch (SecurityException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOGGER.warning("ignore " + e.getMessage());
        }
        return Collections.emptyList();
    }

    private CommandLine getCommandLine(String[] args) {
        try {
            return mavenCliManager.parse(args);
        }
        catch (ParseException e) {
            LOGGER.info("ignore error parsing maven args " + e.getMessage());
            return null;
        }
    }
}

