/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.mavendepsupdate.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.repository.WorkspaceRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReactorReader
implements WorkspaceReader {
    private Map<String, MavenProject> projectsByGAV;
    private Map<String, List<MavenProject>> projectsByGA;
    private WorkspaceRepository repository;
    private File workspaceRoot;

    public ReactorReader(Map<String, MavenProject> reactorProjects, File workspaceRoot) {
        this.projectsByGAV = reactorProjects;
        this.workspaceRoot = workspaceRoot;
        this.projectsByGA = new HashMap(reactorProjects.size() * 2);
        for (MavenProject project : reactorProjects.values()) {
            String key = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            ArrayList<MavenProject> projects = (ArrayList<MavenProject>)this.projectsByGA.get(key);
            if (projects == null) {
                projects = new ArrayList<MavenProject>(1);
                this.projectsByGA.put(key, projects);
            }
            projects.add(project);
        }
        this.repository = new WorkspaceRepository("reactor", new HashSet(this.projectsByGAV.keySet()));
    }

    private File find(MavenProject project, Artifact artifact) {
        if ("pom".equals(artifact.getExtension())) {
            return project.getFile();
        }
        org.apache.maven.artifact.Artifact matchingArtifact = this.findMatchingArtifact(project, artifact);
        if (matchingArtifact != null) {
            return matchingArtifact.getFile();
        }
        return null;
    }

    private org.apache.maven.artifact.Artifact findMatchingArtifact(MavenProject project, Artifact requestedArtifact) {
        org.apache.maven.artifact.Artifact mainArtifact;
        String requestedRepositoryConflictId = this.getConflictId(requestedArtifact);
        if (requestedRepositoryConflictId.equals(this.getConflictId(mainArtifact = project.getArtifact()))) {
            mainArtifact.setFile(new File(this.workspaceRoot, project.getArtifactId()));
            return mainArtifact;
        }
        List attachedArtifacts = project.getAttachedArtifacts();
        if (attachedArtifacts != null && !attachedArtifacts.isEmpty()) {
            for (org.apache.maven.artifact.Artifact attachedArtifact : attachedArtifacts) {
                if (!requestedRepositoryConflictId.equals(this.getConflictId(attachedArtifact))) continue;
                attachedArtifact.setFile(new File(this.workspaceRoot, project.getArtifactId()));
                return attachedArtifact;
            }
        }
        return null;
    }

    private String getConflictId(org.apache.maven.artifact.Artifact artifact) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(artifact.getGroupId());
        buffer.append(':').append(artifact.getArtifactId());
        if (artifact.getArtifactHandler() != null) {
            buffer.append(':').append(artifact.getArtifactHandler().getExtension());
        } else {
            buffer.append(':').append(artifact.getType());
        }
        if (artifact.hasClassifier()) {
            buffer.append(':').append(artifact.getClassifier());
        }
        return buffer.toString();
    }

    private String getConflictId(Artifact artifact) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(artifact.getGroupId());
        buffer.append(':').append(artifact.getArtifactId());
        buffer.append(':').append(artifact.getExtension());
        if (artifact.getClassifier().length() > 0) {
            buffer.append(':').append(artifact.getClassifier());
        }
        return buffer.toString();
    }

    public File findArtifact(Artifact artifact) {
        String projectKey = artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getVersion();
        MavenProject project = (MavenProject)this.projectsByGAV.get(projectKey);
        if (project != null) {
            return this.find(project, artifact);
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        String key = artifact.getGroupId() + ':' + artifact.getArtifactId();
        List projects = (List)this.projectsByGA.get(key);
        if (projects == null || projects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> versions = new ArrayList<String>();
        for (MavenProject project : projects) {
            if (this.find(project, artifact) == null) continue;
            versions.add(project.getVersion());
        }
        return Collections.unmodifiableList(versions);
    }

    public WorkspaceRepository getRepository() {
        return this.repository;
    }
}

