/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.mavendepsupdate;

import hudson.FilePath;
import hudson.PluginFirstClassLoader;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.repository.DelegatingLocalArtifactRepository;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jvnet.hudson.plugins.mavendepsupdate.MavenUpdateCheckerResult;
import org.jvnet.hudson.plugins.mavendepsupdate.util.Maven3Utils;
import org.jvnet.hudson.plugins.mavendepsupdate.util.ReactorReader;
import org.jvnet.hudson.plugins.mavendepsupdate.util.SnapshotTransfertListener;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.repository.ChainedWorkspaceReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenUpdateChecker
implements Callable<MavenUpdateCheckerResult, IOException> {
    private static final Logger LOGGER = Logger.getLogger(MavenUpdateChecker.class.getName());
    private final FilePath mavenShadedJarPath;
    private final String rootPomPath;
    private final String localRepoPath;
    private final boolean checkPlugins;
    private final String projectWorkspace;
    private final boolean masterRun;
    private PluginFirstClassLoader classLoaderParent;
    private FilePath alternateSettings;
    private FilePath globalSettings;
    private Properties userProperties;
    private List<String> activeProfiles = new ArrayList();
    private MavenUpdateCheckerResult mavenUpdateCheckerResult = new MavenUpdateCheckerResult();

    public MavenUpdateChecker(FilePath mavenShadedJarPath, String rootPomPath, String localRepoPath, boolean checkPlugins, String projectWorkspace, boolean masterRun) {
        this.mavenShadedJarPath = mavenShadedJarPath;
        this.rootPomPath = rootPomPath;
        this.localRepoPath = localRepoPath;
        this.checkPlugins = checkPlugins;
        this.projectWorkspace = projectWorkspace;
        this.masterRun = masterRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenUpdateCheckerResult call() throws IOException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            PluginFirstClassLoader pluginFirstClassLoader = this.getPluginFirstClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)pluginFirstClassLoader);
            String classLoaderName = this.getClass().getClassLoader().toString();
            System.out.println("class loader " + classLoaderName);
            this.mavenUpdateCheckerResult.addDebugLine(classLoaderName);
            PlexusContainer plexusContainer = this.getPlexusContainer(pluginFirstClassLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)plexusContainer.getContainerRealm());
            this.mavenUpdateCheckerResult.addDebugLine("ok for new DefaultPlexusContainer( conf ) ");
            this.mavenUpdateCheckerResult.addDebugLine("Thread.currentThread().getContextClassLoader() " + Thread.currentThread().getContextClassLoader());
            this.mavenUpdateCheckerResult.addDebugLine("Thread.currentThread().getContextClassLoader().parent " + (Thread.currentThread().getContextClassLoader().getParent() == null ? "null" : Thread.currentThread().getContextClassLoader().getParent().toString()));
            this.mavenUpdateCheckerResult.addDebugLine("classLoader  urls " + Arrays.asList(plexusContainer.getContainerRealm().getURLs()));
            ProjectBuilder projectBuilder = (ProjectBuilder)plexusContainer.lookup(ProjectBuilder.class);
            Properties userProperties = this.userProperties == null ? new Properties() : this.userProperties;
            ProjectBuildingRequest projectBuildingRequest = this.getProjectBuildingRequest(userProperties, plexusContainer);
            projectBuildingRequest.setProcessPlugins(true);
            projectBuildingRequest.setResolveDependencies(true);
            List projectBuildingResults = projectBuilder.build(Arrays.asList(new File(this.rootPomPath)), true, projectBuildingRequest);
            ProjectDependenciesResolver projectDependenciesResolver = (ProjectDependenciesResolver)plexusContainer.lookup(ProjectDependenciesResolver.class);
            ArrayList<MavenProject> mavenProjects = new ArrayList<MavenProject>(projectBuildingResults.size());
            for (ProjectBuildingResult projectBuildingResult : projectBuildingResults) {
                mavenProjects.add(projectBuildingResult.getProject());
            }
            ProjectSorter projectSorter = new ProjectSorter(mavenProjects);
            Map projectMap = this.getProjectMap(mavenProjects);
            ReactorReader reactorRepository = new ReactorReader(projectMap, new File(this.projectWorkspace));
            MavenRepositorySystemSession mavenRepositorySystemSession = (MavenRepositorySystemSession)projectBuildingRequest.getRepositorySession();
            mavenRepositorySystemSession.setUpdatePolicy("always");
            mavenRepositorySystemSession.setWorkspaceReader(ChainedWorkspaceReader.newInstance((WorkspaceReader)reactorRepository, (WorkspaceReader)projectBuildingRequest.getRepositorySession().getWorkspaceReader()));
            MavenPluginManager mavenPluginManager = (MavenPluginManager)plexusContainer.lookup(MavenPluginManager.class);
            for (MavenProject mavenProject : projectSorter.getSortedProjects()) {
                LOGGER.info("resolve dependencies for project " + mavenProject.getId());
                DefaultDependencyResolutionRequest dependencyResolutionRequest = new DefaultDependencyResolutionRequest(mavenProject, (RepositorySystemSession)mavenRepositorySystemSession);
                DependencyResolutionResult dependencyResolutionResult = projectDependenciesResolver.resolve((DependencyResolutionRequest)dependencyResolutionRequest);
                if (!this.checkPlugins) continue;
                for (Plugin plugin : mavenProject.getBuildPlugins()) {
                    if (!StringUtils.endsWith((String)plugin.getVersion(), (String)"SNAPSHOT")) continue;
                    mavenPluginManager.getPluginDescriptor(plugin, mavenProject.getRemotePluginRepositories(), (RepositorySystemSession)mavenRepositorySystemSession);
                }
            }
            SnapshotTransfertListener snapshotTransfertListener = (SnapshotTransfertListener)projectBuildingRequest.getRepositorySession().getTransferListener();
            if (snapshotTransfertListener.isSnapshotDownloaded()) {
                this.mavenUpdateCheckerResult.addFilesUpdatedNames(snapshotTransfertListener.getSnapshots());
            }
        }
        catch (Exception e) {
            this.mavenUpdateCheckerResult.addDebugLine(e.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.mavenUpdateCheckerResult.addDebugLine(sw.toString());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return this.mavenUpdateCheckerResult;
    }

    private PlexusContainer getPlexusContainer(PluginFirstClassLoader pluginFirstClassLoader) throws MalformedURLException, IOException, InterruptedException, PlexusContainerException {
        if (this.masterRun) {
            return Maven3Utils.getPlexusContainer((PluginFirstClassLoader)this.classLoaderParent);
        }
        DefaultContainerConfiguration conf = new DefaultContainerConfiguration();
        ClassWorld world = new ClassWorld();
        ClassRealm classRealm = new ClassRealm(world, "project-building", (ClassLoader)pluginFirstClassLoader);
        for (URL url : pluginFirstClassLoader.getURLs()) {
            classRealm.addURL(url);
            this.mavenUpdateCheckerResult.addDebugLine("add url " + url.toExternalForm());
        }
        conf.setRealm(classRealm);
        this.mavenUpdateCheckerResult.addDebugLine("before  return new DefaultPlexusContainer( conf ) ");
        return new DefaultPlexusContainer((ContainerConfiguration)conf);
    }

    PluginFirstClassLoader getPluginFirstClassLoader() throws MalformedURLException, IOException, InterruptedException {
        PluginFirstClassLoader pluginFirstClassLoader = new PluginFirstClassLoader();
        pluginFirstClassLoader.setParent((ClassLoader)(this.masterRun ? this.classLoaderParent : Thread.currentThread().getContextClassLoader()));
        pluginFirstClassLoader.setParentFirst(!this.masterRun);
        String mavenShadedJarPathStr = this.mavenShadedJarPath.getRemote();
        this.mavenUpdateCheckerResult.addDebugLine("add mavenShadedJarPathStr " + mavenShadedJarPathStr);
        ArrayList<File> jarFiles = new ArrayList<File>(1);
        jarFiles.add(new File(mavenShadedJarPathStr));
        pluginFirstClassLoader.addPathFiles(jarFiles);
        this.mavenUpdateCheckerResult.addDebugLine("pluginFirstClassLoader end");
        return pluginFirstClassLoader;
    }

    ProjectBuildingRequest getProjectBuildingRequest(Properties userProperties, PlexusContainer plexusContainer) throws ComponentLookupException, SettingsBuildingException, MavenExecutionRequestPopulationException, InvalidRepositoryException {
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setLoggingLevel(0);
        SettingsBuilder settingsBuilder = (SettingsBuilder)plexusContainer.lookup(SettingsBuilder.class);
        org.apache.maven.repository.RepositorySystem repositorySystem = (org.apache.maven.repository.RepositorySystem)plexusContainer.lookup(org.apache.maven.repository.RepositorySystem.class);
        RepositorySystem repoSystem = (RepositorySystem)plexusContainer.lookup(RepositorySystem.class);
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        if (this.globalSettings != null) {
            this.mavenUpdateCheckerResult.addDebugLine("globalSettings " + this.globalSettings.getRemote());
            settingsRequest.setGlobalSettingsFile(new File(this.globalSettings.getRemote()));
        } else {
            settingsRequest.setGlobalSettingsFile(new File(System.getProperty("maven.home", System.getProperty("user.dir", "")), "conf/settings.xml"));
        }
        if (this.alternateSettings != null) {
            this.mavenUpdateCheckerResult.addDebugLine("alternateSettings " + this.alternateSettings.getRemote());
            settingsRequest.setUserSettingsFile(new File(this.alternateSettings.getRemote()));
        } else {
            settingsRequest.setUserSettingsFile(new File(new File(System.getProperty("user.home"), ".m2"), "settings.xml"));
        }
        settingsRequest.setSystemProperties(System.getProperties());
        settingsRequest.setUserProperties(userProperties);
        SettingsBuildingResult settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsRequest);
        MavenExecutionRequestPopulator executionRequestPopulator = (MavenExecutionRequestPopulator)plexusContainer.lookup(MavenExecutionRequestPopulator.class);
        executionRequestPopulator.populateFromSettings((MavenExecutionRequest)request, settingsBuildingResult.getEffectiveSettings());
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        session.setUpdatePolicy("always");
        SnapshotTransfertListener snapshotTransfertListener = new SnapshotTransfertListener();
        session.setTransferListener((TransferListener)snapshotTransfertListener);
        LocalRepository localRepo = new LocalRepository(this.localRepoPath);
        session.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager(localRepo));
        ArtifactRepository localArtifactRepository = repositorySystem.createLocalRepository(new File(this.localRepoPath));
        request.setLocalRepository((ArtifactRepository)new DelegatingLocalArtifactRepository(localArtifactRepository));
        if (this.activeProfiles != null && !this.activeProfiles.isEmpty()) {
            for (String id : this.activeProfiles) {
                Profile p = new Profile();
                p.setId(id);
                p.setSource("cli");
                request.addProfile(p);
                request.addActiveProfile(id);
            }
        }
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        return projectBuildingRequest.setRepositorySession((RepositorySystemSession)session);
    }

    private Map<String, MavenProject> getProjectMap(List<MavenProject> projects) {
        LinkedHashMap<String, MavenProject> index = new LinkedHashMap<String, MavenProject>();
        for (MavenProject project : projects) {
            String projectId = ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
            index.put(projectId, project);
        }
        return index;
    }

    public void setClassLoaderParent(PluginFirstClassLoader classLoaderParent) {
        this.classLoaderParent = classLoaderParent;
    }

    public void setAlternateSettings(FilePath alternateSettings) {
        this.alternateSettings = alternateSettings;
    }

    public void setGlobalSettings(FilePath globalSettings) {
        this.globalSettings = globalSettings;
    }

    public void setUserProperties(Properties userProperties) {
        this.userProperties = userProperties;
    }

    public void setActiveProfiles(List<String> activeProfiles) {
        this.activeProfiles = activeProfiles;
    }
}

