/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.mavendepsupdate.util;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.mavendepsupdate.MavenDependencyUpdateTrigger;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotTransfertListener
implements TransferListener,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(SnapshotTransfertListener.class.getName());
    private boolean snapshotDownloaded = false;
    private List<String> snapshots = new ArrayList();

    public void transferCorrupted(TransferEvent transferEvent) throws TransferCancelledException {
    }

    public void transferFailed(TransferEvent transferEvent) {
    }

    public void transferInitiated(TransferEvent transferEvent) throws TransferCancelledException {
    }

    public void transferProgressed(TransferEvent transferEvent) throws TransferCancelledException {
    }

    public void transferStarted(TransferEvent transferEvent) throws TransferCancelledException {
    }

    public void transferSucceeded(TransferEvent transferEvent) {
        File file;
        if (transferEvent != null && transferEvent.getResource() != null && (file = transferEvent.getResource().getFile()) != null && transferEvent.getResource().getResourceName().contains("SNAPSHOT")) {
            boolean isArtifact;
            boolean bl = isArtifact = !StringUtils.contains((String)file.getName(), (String)"maven-metadata") && !StringUtils.endsWith((String)file.getName(), (String)".xml");
            if (isArtifact) {
                LOGGER.info("download " + file.getName());
                this.snapshots.add(file.getName());
                this.snapshotDownloaded = true;
            } else if (MavenDependencyUpdateTrigger.debug) {
                LOGGER.info("ignore file " + file.getName());
            }
        }
    }

    public boolean isSnapshotDownloaded() {
        return this.snapshotDownloaded;
    }

    public List<String> getSnapshots() {
        return this.snapshots;
    }
}

