/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mavendeploymentlinker;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.mavendeploymentlinker.MavenDeploymentLinkerAction;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenDeploymentLinkerRecorder
extends Recorder {
    @DataBoundConstructor
    public MavenDeploymentLinkerRecorder() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String line;
        File logFile = build.getLogFile();
        BufferedReader in = new BufferedReader(new FileReader(logFile));
        Pattern pattern = Pattern.compile("^.*?Uploading: (.*?)$");
        ArrayList<String> matches = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            matches.add(matcher.group(1));
        }
        if (matches.size() > 0) {
            MavenDeploymentLinkerAction action = new MavenDeploymentLinkerAction();
            for (String url : matches) {
                action.addDeployment(url);
            }
            build.getActions().add(action);
            build.save();
        }
        return super.perform(build, launcher, listener);
    }
}

