/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mavendeploymentlinker;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.mavendeploymentlinker.MavenDeploymentLinkerAction;
import hudson.util.RunList;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenDeploymentProjectLinkerAction
implements Action {
    private final AbstractProject<?, ?> project;

    public MavenDeploymentProjectLinkerAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "";
    }

    @Exported
    public boolean hasLatestDeployments() {
        return this.getLatestDeployments() != null;
    }

    @Exported
    public Action getLatestDeployments() {
        Run lastSuccessfulBuild = this.project.getLastSuccessfulBuild();
        if (lastSuccessfulBuild == null) {
            return null;
        }
        return lastSuccessfulBuild.getAction(MavenDeploymentLinkerAction.class);
    }

    @Exported
    public boolean hasLatestReleaseDeployments() {
        return this.getLatestReleaseDeployments() != null;
    }

    @Exported
    public Action getLatestReleaseDeployments() {
        RunList builds = this.project.getBuilds();
        for (Run run : builds) {
            MavenDeploymentLinkerAction linkerAction;
            if (!this.isSuccessful(run) || (linkerAction = (MavenDeploymentLinkerAction)run.getAction(MavenDeploymentLinkerAction.class)).isSnapshot()) continue;
            return linkerAction;
        }
        return null;
    }

    private boolean isSuccessful(Run run) {
        return !run.isBuilding() && run.getResult() != null && !run.getResult().isWorseThan(Result.UNSTABLE);
    }
}

