/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mavendeploymentlinker;

import hudson.model.Action;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.kohsuke.stapler.export.Exported;

public class MavenDeploymentLinkerAction
implements Action {
    private List<ArtifactVersion> deployments = new ArrayList<ArtifactVersion>();
    private transient String text;
    private boolean snapshot = false;

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "";
    }

    @Exported
    public String getText() {
        if (this.text == null) {
            StringBuilder textBuilder = new StringBuilder();
            textBuilder.append("<ul>");
            for (ArtifactVersion artifact : this.deployments) {
                textBuilder.append(artifact.getText());
            }
            textBuilder.append("</ul>");
            this.text = textBuilder.toString();
        }
        return this.text;
    }

    public void addDeployment(String url) {
        ArtifactVersion artifactVersion = new ArtifactVersion(url);
        if (artifactVersion.isSnapshot()) {
            this.snapshot = true;
        }
        this.deployments.add(artifactVersion);
    }

    private static class ArtifactVersion {
        private static final String SNAPSHOT_PATTERN = ".*-SNAPSHOT.*";
        private static final Pattern p = Pattern.compile(".*-SNAPSHOT.*");
        private final String url;
        private boolean snapshot;

        private ArtifactVersion(String url) {
            this.url = url;
            this.checkRelease();
        }

        private void checkRelease() {
            this.snapshot = p.matcher(this.url).matches();
        }

        public boolean isSnapshot() {
            return this.snapshot;
        }

        public String getText() {
            StringBuilder textBuilder = new StringBuilder();
            textBuilder.append("\n<li>");
            textBuilder.append("<a href=\"" + this.url + "\">");
            textBuilder.append(this.url.substring(this.url.lastIndexOf(47) + 1, this.url.length()));
            textBuilder.append("</a>");
            textBuilder.append("</li>\n");
            return textBuilder.toString();
        }
    }
}

