/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mavendeploymentlinker;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.mavendeploymentlinker.MavenDeploymentLinkerAction;
import hudson.plugins.mavendeploymentlinker.MavenDeploymentProjectLinkerAction;
import hudson.plugins.mavendeploymentlinker.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenDeploymentLinkerRecorder
extends Recorder {
    private static final String IGNORED_RESOURCES = "^.*maven-metadata.xml$";
    private String regexp;

    @DataBoundConstructor
    public MavenDeploymentLinkerRecorder(String regexp) {
        this.regexp = StringUtils.trimToEmpty((String)regexp);
    }

    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String line;
        File logFile = build.getLogFile();
        BufferedReader in = new BufferedReader(new FileReader(logFile));
        Pattern pattern = Pattern.compile("^.*?Uploading: (.*?)$");
        Pattern filterPattern = Pattern.compile(StringUtils.isNotBlank((String)this.regexp) ? this.regexp : ".*");
        Pattern ignoredPattern = Pattern.compile(IGNORED_RESOURCES);
        ArrayList<String> matches = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            String candidate = matcher.group(1);
            Matcher filterMatcher = filterPattern.matcher(candidate);
            Matcher ignoredMatcher = ignoredPattern.matcher(candidate);
            if (!filterMatcher.matches() || ignoredMatcher.matches()) continue;
            matches.add(candidate);
        }
        if (matches.size() > 0) {
            MavenDeploymentLinkerAction action = new MavenDeploymentLinkerAction();
            for (String url : matches) {
                action.addDeployment(url);
            }
            build.getActions().add(action);
            build.save();
        }
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new MavenDeploymentProjectLinkerAction(project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.MavenDeploymentLinkerRecorder_DisplayName();
        }
    }
}

