/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.measurement_plots;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.measurement_plots.BuildMeasurements;
import hudson.plugins.measurement_plots.Measurement;
import hudson.plugins.measurement_plots.TestAction;
import hudson.plugins.measurement_plots.TestActionResolver;
import hudson.plugins.measurement_plots.TestObjectId;
import hudson.plugins.measurement_plots.TestObjectMeasurements;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestObject;
import hudson.util.HeapSpaceStringConverter;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestActionResolver
extends TestResultAction.Data {
    private static final Logger LOGGER = Logger.getLogger(TestActionResolver.class.getName());
    private static final XStream XSTREAM = new XStream2();
    private transient WeakReference<BuildMeasurements> weakBuildMeasurements;
    private transient AbstractBuild<?, ?> build;
    private final transient BuildListener listener;

    TestActionResolver(BuildMeasurements buildMeasurements, AbstractBuild<?, ?> build, BuildListener listener) {
        this.build = build;
        this.listener = listener;
        this.setBuildMeasurements(buildMeasurements, listener);
    }

    public List<hudson.tasks.junit.TestAction> getTestAction(hudson.tasks.junit.TestObject junitTestObject) {
        TestObjectMeasurements testObjectMeasurements;
        if (this.build == null) {
            this.build = junitTestObject.getOwner();
        }
        if ((testObjectMeasurements = (TestObjectMeasurements)this.getBuildMeasurements().get((Object)TestObjectId.fromString((String)junitTestObject.getId()))) != null && !testObjectMeasurements.isEmpty()) {
            TestObject testObject = (TestObject)junitTestObject;
            return Collections.singletonList(new TestAction(testObject, testObjectMeasurements));
        }
        return Collections.emptyList();
    }

    public synchronized BuildMeasurements getBuildMeasurements() {
        BuildMeasurements buildMeasurements;
        if (this.weakBuildMeasurements == null) {
            buildMeasurements = this.load();
            this.weakBuildMeasurements = new WeakReference<BuildMeasurements>(buildMeasurements);
        } else {
            buildMeasurements = (BuildMeasurements)this.weakBuildMeasurements.get();
        }
        if (buildMeasurements == null) {
            buildMeasurements = this.load();
            this.weakBuildMeasurements = new WeakReference<BuildMeasurements>(buildMeasurements);
        }
        return buildMeasurements;
    }

    public synchronized void setBuildMeasurements(BuildMeasurements buildMeasurements, BuildListener listener) {
        try {
            this.getDataFile().write((Object)buildMeasurements);
        }
        catch (IOException exception) {
            exception.printStackTrace(listener.fatalError("Failed to save build measurements"));
        }
        this.weakBuildMeasurements = new WeakReference<BuildMeasurements>(buildMeasurements);
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.build.getRootDir(), "measurement-plots.xml"));
    }

    private BuildMeasurements load() {
        BuildMeasurements loadedMeasurements;
        try {
            loadedMeasurements = (BuildMeasurements)this.getDataFile().read();
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to load " + this.getDataFile(), exception);
            loadedMeasurements = new BuildMeasurements();
        }
        return loadedMeasurements;
    }

    static {
        XSTREAM.registerConverter((Converter)new BuildMeasurementsConverter(XSTREAM.getMapper()));
        XSTREAM.alias("build-measurements", BuildMeasurements.class);
        XSTREAM.alias("test-object", Map.Entry.class);
        XSTREAM.registerConverter((SingleValueConverter)new TestObjectIdConverter(null));
        XSTREAM.alias("id", TestObjectId.class);
        XSTREAM.registerConverter((Converter)new TestObjectMeasurementsConverter(XSTREAM.getMapper()));
        XSTREAM.alias("measurements", TestObjectMeasurements.class);
        XSTREAM.alias("measurement", Measurement.class);
        XSTREAM.registerConverter((SingleValueConverter)new HeapSpaceStringConverter(), 100);
    }
}

