/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.measurement_plots;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import hudson.plugins.measurement_plots.Measurement;
import hudson.plugins.measurement_plots.TestObjectMeasurements;
import hudson.util.XStream2;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class OutputParser {
    private static final String REGEX = "(<measurement>.+?</measurement>)";
    private static final Logger LOGGER = Logger.getLogger(OutputParser.class.getName());
    private static final Pattern PATTERN = Pattern.compile("(<measurement>.+?</measurement>)");
    private static final XStream XSTREAM = new XStream2();

    OutputParser() {
    }

    TestObjectMeasurements parse(String text) {
        TestObjectMeasurements measurements = new TestObjectMeasurements();
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            try {
                Measurement measurement = (Measurement)XSTREAM.fromXML(matcher.group(1));
                if (measurement == null) continue;
                measurements.add(measurement);
            }
            catch (XStreamException exception) {}
        }
        return measurements;
    }

    static {
        XSTREAM.alias("measurement", Measurement.class);
    }
}

