/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialChangeSet
extends ChangeLogSet.Entry {
    private String node;
    private String author;
    private long rev;
    private String date;
    private String msg;
    private boolean merge;
    private List<String> added = Collections.emptyList();
    private List<String> deleted = Collections.emptyList();
    private List<String> modified = Collections.emptyList();
    private volatile List<String> affectedPaths;
    static final String CHANGELOG_TEMPLATE_09x = "<changeset node='{node}' author='{author|escape}' rev='{rev}' date='{date}'><msg>{desc|escape}</msg><added>{file_adds|stringify|escape}</added><deleted>{file_dels|stringify|escape}</deleted><files>{files|stringify|escape}</files><parents>{parents}</parents></changeset>\\n";
    static final String CHANGELOG_TEMPLATE_10x = "<changeset node='{node}' author='{author|xmlescape}' rev='{rev}' date='{date}'><msg>{desc|xmlescape}</msg><added>{file_adds|stringify|xmlescape}</added><deleted>{file_dels|stringify|xmlescape}</deleted><files>{files|stringify|xmlescape}</files><parents>{parents}</parents></changeset>\\n";

    public String getMsg() {
        return this.msg;
    }

    public User getAuthor() {
        return User.get((String)this.author);
    }

    public String getNode() {
        return this.node;
    }

    public String getShortNode() {
        return this.node.substring(0, 12);
    }

    public long getRev() {
        return this.rev;
    }

    public String getDate() {
        return this.date;
    }

    public Collection<String> getAffectedPaths() {
        if (this.affectedPaths == null) {
            ArrayList<String> r = new ArrayList<String>(this.added.size() + this.modified.size() + this.deleted.size());
            r.addAll(this.added);
            r.addAll(this.modified);
            r.addAll(this.deleted);
            this.affectedPaths = r;
        }
        return this.affectedPaths;
    }

    public List<String> getAddedPaths() {
        return this.added;
    }

    public List<String> getDeletedPaths() {
        return this.deleted;
    }

    public List<String> getModifiedPaths() {
        return this.modified;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public List<String> getPaths(EditType kind) {
        if (kind == EditType.ADD) {
            return this.getAddedPaths();
        }
        if (kind == EditType.EDIT) {
            return this.getModifiedPaths();
        }
        if (kind == EditType.DELETE) {
            return this.getDeletedPaths();
        }
        return null;
    }

    public List<EditType> getEditTypes() {
        return Arrays.asList(EditType.ADD, EditType.EDIT, EditType.DELETE);
    }

    protected void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    @Deprecated
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Deprecated
    public void setNode(String node) {
        this.node = node;
    }

    @Deprecated
    public void setUser(String author) {
        this.author = author;
    }

    @Deprecated
    public String getUser() {
        return this.author;
    }

    @Deprecated
    public void setAuthor(String author) {
        this.author = author;
    }

    @Deprecated
    public void setRev(long rev) {
        this.rev = rev;
    }

    @Deprecated
    public void setDate(String date) {
        this.date = date;
    }

    @Deprecated
    public void setAdded(String list) {
        this.added = this.toList(list);
    }

    @Deprecated
    public void setDeleted(String list) {
        this.deleted = this.toList(list);
    }

    @Deprecated
    public void setFiles(String list) {
        this.modified = this.toList(list);
        if (!this.added.isEmpty() || !this.deleted.isEmpty()) {
            this.modified = new ArrayList<String>(this.modified);
            this.modified.removeAll(this.added);
            this.modified.removeAll(this.deleted);
        }
    }

    @Deprecated
    public void setParents(String parents) {
        this.merge = parents.indexOf(58) != parents.lastIndexOf(58) && !parents.contains("-1");
    }

    private List<String> toList(String list) {
        if ((list = list.trim()).length() == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(list.split(" "));
    }
}

