/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.HgRc;
import hudson.plugins.mercurial.MercurialChangeLogParser;
import hudson.plugins.mercurial.browser.HgWeb;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.ByteBuffer;
import hudson.util.ForkOutputStream;
import hudson.util.FormFieldValidator;
import hudson.util.TextFile;
import hudson.util.VersionNumber;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialSCM
extends SCM
implements Serializable {
    private final String source;
    private final transient Set<String> _modules = new HashSet<String>();
    private final String modules;
    private final String branch;
    private HgWeb browser;
    private static final String FILES_STYLE = "changeset = 'files:{files}\\n'\nfile = '{file}:'";
    private static Pattern FILES_LINE = Pattern.compile("files:(.*)");
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MercurialSCM.class.getName());

    @DataBoundConstructor
    public MercurialSCM(String source, String branch, String modules, HgWeb browser) {
        this.source = source;
        this.modules = modules;
        String[] r = modules.split("(?<!\\\\)[ \\r\\n,]+");
        for (int i = 0; i < r.length; ++i) {
            r[i] = r[i].replaceAll("\\\\ ", " ");
            while (r[i].startsWith("/")) {
                r[i] = r[i].substring(1);
            }
            r[i] = r[i].replace('\\', '/');
        }
        this._modules.addAll(Arrays.asList(r));
        branch = Util.fixEmpty((String)branch);
        if (branch != null && branch.equals("default")) {
            branch = null;
        }
        this.branch = branch;
        this.browser = browser;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch;
    }

    public HgWeb getBrowser() {
        return this.browser;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        PrintStream output = listener.getLogger();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        File tmpFile = File.createTempFile("tmp", "style");
        TextFile tmpTxt = new TextFile(tmpFile);
        tmpTxt.write(FILES_STYLE);
        launcher.launch(new String[]{this.getDescriptor().getHgExe(), "incoming", "--style", tmpFile.getCanonicalPath()}, EnvVars.masterEnvVars, (OutputStream)new ForkOutputStream((OutputStream)baos, (OutputStream)output), workspace).join();
        HashSet<String> changedFileNames = new HashSet<String>();
        this.parseIncomingOutput(baos, changedFileNames);
        tmpFile.delete();
        if (changedFileNames.isEmpty()) {
            output.println("No changes");
            return false;
        }
        if (this.dependentChanges(changedFileNames).isEmpty()) {
            output.println("Non-dependent changes detected");
            return false;
        }
        output.println("Dependent changes detected");
        return true;
    }

    private Set<String> dependentChanges(Set<String> changedFileNames) {
        if (this._modules == null) {
            return changedFileNames;
        }
        HashSet<String> affecting = new HashSet<String>();
        block0: for (String changedFile : changedFileNames) {
            for (String dependency : this._modules) {
                if (!changedFile.startsWith(dependency)) continue;
                affecting.add(changedFile);
                continue block0;
            }
        }
        return affecting;
    }

    private void parseIncomingOutput(ByteArrayOutputStream output, Set<String> result) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.toByteArray())));
        while ((line = in.readLine()) != null) {
            Matcher matcher = FILES_LINE.matcher(line);
            if (!matcher.matches()) continue;
            for (String s : matcher.group(1).split(":")) {
                if (s.length() <= 0) continue;
                result.add(s);
            }
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean canUpdate = (Boolean)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

            public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
                if (!HgRc.getHgRcFile(ws).exists()) {
                    return false;
                }
                HgRc hgrc = new HgRc(ws);
                return this.canUpdate(hgrc);
            }

            private boolean canUpdate(HgRc ini) {
                String upstream = ini.getSection("paths").get("default");
                if (upstream == null) {
                    return false;
                }
                if (upstream.equals(MercurialSCM.this.source)) {
                    return true;
                }
                return MercurialSCM.this.source.startsWith("file:/") && new File(upstream).toURI().toString().equals(MercurialSCM.this.source);
            }
        });
        if (canUpdate) {
            return this.update(build, launcher, workspace, listener, changelogFile);
        }
        return this.clone(build, launcher, workspace, listener, changelogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException, IOException {
        int r;
        FilePath hgBundle = new FilePath(workspace, "hg.bundle");
        hgBundle.delete();
        FileOutputStream os = new FileOutputStream(changelogFile);
        os.write("<changesets>\n".getBytes());
        try {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{this.getDescriptor().getHgExe(), "incoming", "--quiet", "--bundle", "hg.bundle"});
            String template = "<changeset node='{node}' author='{author|escape}' rev='{rev}' date='{date}'><msg>{desc|escape}</msg><added>{file_adds|stringify|escape}</added><deleted>{file_dels|stringify|escape}</deleted><files>{files|stringify|escape}</files><parents>{parents}</parents></changeset>\\n";
            if (this.isHg10orLater()) {
                template = "<changeset node='{node}' author='{author|xmlescape}' rev='{rev}' date='{date}'><msg>{desc|xmlescape}</msg><added>{file_adds|stringify|xmlescape}</added><deleted>{file_dels|stringify|xmlescape}</deleted><files>{files|stringify|xmlescape}</files><parents>{parents}</parents></changeset>\\n";
                args.add("--debug");
            }
            args.add(new String[]{"--template", template});
            if (this.branch != null) {
                args.add(new String[]{"-r", this.branch});
            }
            ByteArrayOutputStream errorLog = new ByteArrayOutputStream();
            WriterOutputStream o = new WriterOutputStream((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"));
            try {
                r = launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)new ForkOutputStream((OutputStream)o, (OutputStream)errorLog), workspace).join();
            }
            finally {
                o.flush();
            }
            if (r != 0 && r != 1) {
                Util.copyStream((InputStream)new ByteArrayInputStream(errorLog.toByteArray()), (OutputStream)listener.getLogger());
                listener.error("Failed to determine incoming changes");
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            listener.error("Failed to pull");
            boolean bl = false;
            return bl;
        }
        finally {
            os.write("</changesets>".getBytes());
            os.close();
        }
        if (r == 0 && hgBundle.exists()) {
            try {
                if (launcher.launch(new String[]{this.getDescriptor().getHgExe(), "pull", "-u", "hg.bundle"}, build.getEnvVars(), (OutputStream)listener.getLogger(), workspace).join() != 0) {
                    listener.error("Failed to pull");
                    return false;
                }
            }
            catch (IOException e) {
                listener.error("Failed to pull");
                return false;
            }
        }
        hgBundle.delete();
        return true;
    }

    private boolean isHg10orLater() {
        boolean hg10 = false;
        try {
            String v = this.getDescriptor().findHgVersion();
            try {
                if (v != null && new VersionNumber(v).compareTo(new VersionNumber("1.0")) >= 0) {
                    hg10 = true;
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.INFO, "Failed to parse Mercurial version number: " + v, e);
            }
        }
        catch (IOException x) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return hg10;
    }

    private boolean clone(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException {
        try {
            workspace.deleteRecursive();
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clean the workspace"));
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getDescriptor().getHgExe(), "clone"});
        if (this.branch != null) {
            args.add(new String[]{"-r", this.branch});
        }
        args.add(new String[]{this.source, workspace.getRemote()});
        try {
            if (launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)listener.getLogger(), null).join() != 0) {
                listener.error("Failed to clone " + this.source);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clone " + this.source));
            return false;
        }
        return this.createEmptyChangeLog(changelogFile, listener, "changelog");
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
    }

    public ChangeLogParser createChangeLogParser() {
        return new MercurialChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public String getModules() {
        return this.modules;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends SCMDescriptor<MercurialSCM> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private String hgExe;
        private transient String version;
        private static final Pattern VERSION_STRING = Pattern.compile("\\(version ([0-9.]+)");
        private static final Pattern UUID_VERSION_STRING = Pattern.compile("\\(version ([0-9a-f]+)");
        private static final VersionNumber V0_9_4 = new VersionNumber("0.9.4");

        private DescriptorImpl() {
            super(MercurialSCM.class, HgWeb.class);
            this.load();
        }

        public String getDisplayName() {
            return "Mercurial";
        }

        public String getHgExe() {
            if (this.hgExe == null) {
                return "hg";
            }
            return this.hgExe;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new MercurialSCM(req.getParameter("mercurial.source"), req.getParameter("mercurial.branch"), req.getParameter("mercurial.modules"), (HgWeb)RepositoryBrowsers.createInstance(HgWeb.class, (StaplerRequest)req, (String)"mercurial.browser"));
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.hgExe = req.getParameter("mercurial.hgExe");
            this.version = null;
            this.save();
            return true;
        }

        public void doHgExeCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.Executable(req, rsp){

                protected void checkExecutable(File exe) throws IOException, ServletException {
                    try {
                        String v = DescriptorImpl.this.findHgVersion();
                        if (v != null) {
                            try {
                                if (new VersionNumber(v).compareTo(V0_9_4) >= 0) {
                                    this.ok();
                                } else {
                                    this.error("This hg is ver." + v + " but we need 0.9.4+");
                                }
                            }
                            catch (IllegalArgumentException e) {
                                this.warning("Hudson can't tell if this hg is 0.9.4 or later (detected version is %s)", new Object[]{v});
                            }
                            return;
                        }
                        v = DescriptorImpl.this.findHgVersion(UUID_VERSION_STRING);
                        if (v != null) {
                            this.warning("Hudson can't tell if this hg is 0.9.4 or later (detected version is %s)", new Object[]{v});
                            return;
                        }
                    }
                    catch (IOException e) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.error("Unable to check hg version");
                }
            }.process();
        }

        private String findHgVersion() throws IOException, InterruptedException {
            return this.findHgVersion(VERSION_STRING);
        }

        private String findHgVersion(Pattern p) throws IOException, InterruptedException {
            if (this.version != null) {
                return this.version;
            }
            ByteBuffer baos = new ByteBuffer();
            Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch(new String[]{this.getHgExe(), "version"}, new String[0], (OutputStream)baos, null);
            proc.join();
            Matcher m = p.matcher(baos.toString());
            if (m.find()) {
                this.version = m.group(1);
                return this.version;
            }
            return null;
        }
    }
}

