/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.HgRc;
import hudson.plugins.mercurial.MercurialChangeLogParser;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialTagAction;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.plugins.mercurial.browser.HgWeb;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.ForkOutputStream;
import hudson.util.VersionNumber;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.framework.io.ByteBuffer;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialSCM
extends SCM
implements Serializable {
    private final String installation;
    private final String source;
    private final transient Set<String> _modules = new HashSet<String>();
    private final String modules;
    private final String branch;
    private final boolean clean;
    private HgBrowser browser;
    private static final String FILES_STYLE = "changeset = 'files:{files}\\n'\nfile = '{file}:'";
    private static Pattern FILES_LINE = Pattern.compile("files:(.*)");
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MercurialSCM.class.getName());
    private static final Pattern REVISIONID_PATTERN = Pattern.compile("[0-9a-f]{40}");

    @DataBoundConstructor
    public MercurialSCM(String installation, String source, String branch, String modules, HgBrowser browser, boolean clean) {
        this.installation = installation;
        this.source = source;
        this.modules = Util.fixNull((String)modules);
        this.clean = clean;
        String[] r = this.modules.split("(?<!\\\\)[ \\r\\n,]+");
        for (int i = 0; i < r.length; ++i) {
            r[i] = r[i].replaceAll("\\\\ ", " ");
            while (r[i].startsWith("/")) {
                r[i] = r[i].substring(1);
            }
            r[i] = r[i].replace('\\', '/');
        }
        this._modules.addAll(Arrays.asList(r));
        branch = Util.fixEmpty((String)branch);
        if (branch != null && branch.equals("default")) {
            branch = null;
        }
        this.branch = branch;
        this.browser = browser;
    }

    public String getInstallation() {
        return this.installation;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch == null ? "default" : this.branch;
    }

    public HgBrowser getBrowser() {
        if (this.browser == null) {
            try {
                return new HgWeb(this.source);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.browser;
    }

    public boolean isClean() {
        return this.clean;
    }

    private String findHgExe(TaskListener listener) throws IOException, InterruptedException {
        for (MercurialInstallation inst : MercurialInstallation.allInstallations()) {
            if (!inst.getName().equals(this.installation)) continue;
            return inst.forNode(Computer.currentComputer().getNode(), listener).getHome() + "/bin/hg";
        }
        return this.getDescriptor().getHgExe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        PrintStream output = listener.getLogger();
        HashSet<String> changedFileNames = new HashSet<String>();
        FilePath tmpFile = workspace.createTextTempFile("tmp", "style", FILES_STYLE);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ArgumentListBuilder cmd = new ArgumentListBuilder();
            cmd.add(new String[]{this.findHgExe(listener), "incoming", "--style", tmpFile.getRemote()});
            cmd.add(new String[]{"-r", this.getBranch()});
            this.joinWithTimeout(launcher.launch().cmds(cmd).stdout((OutputStream)new ForkOutputStream((OutputStream)baos, (OutputStream)output)).pwd(workspace).start(), 1L, TimeUnit.HOURS, listener);
            this.parseIncomingOutput(baos, changedFileNames);
        }
        finally {
            tmpFile.delete();
        }
        if (changedFileNames.isEmpty()) {
            output.println("No changes");
            return false;
        }
        if (this.dependentChanges(changedFileNames).isEmpty()) {
            output.println("Non-dependent changes detected");
            return false;
        }
        output.println("Dependent changes detected");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int joinWithTimeout(final Proc proc, long timeout, TimeUnit unit, final TaskListener listener) throws IOException, InterruptedException {
        final AtomicBoolean done = new AtomicBoolean();
        try {
            Executors.newSingleThreadScheduledExecutor().schedule(new Runnable(){

                public void run() {
                    if (!done.get()) {
                        try {
                            proc.kill();
                        }
                        catch (Exception x) {
                            listener.error(x.toString());
                        }
                    }
                }
            }, timeout, unit);
            int n = proc.join();
            return n;
        }
        finally {
            done.set(true);
        }
    }

    private Set<String> dependentChanges(Set<String> changedFileNames) {
        if (this._modules == null) {
            return changedFileNames;
        }
        HashSet<String> affecting = new HashSet<String>();
        block0: for (String changedFile : changedFileNames) {
            for (String dependency : this._modules) {
                if (!changedFile.startsWith(dependency)) continue;
                affecting.add(changedFile);
                continue block0;
            }
        }
        return affecting;
    }

    private void parseIncomingOutput(ByteArrayOutputStream output, Set<String> result) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.toByteArray())));
        while ((line = in.readLine()) != null) {
            Matcher matcher = FILES_LINE.matcher(line);
            if (!matcher.matches()) continue;
            for (String s : matcher.group(1).split(":")) {
                if (s.length() <= 0) continue;
                result.add(s);
            }
        }
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, final BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean canUpdate = (Boolean)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

            public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
                if (!HgRc.getHgRcFile(ws).exists()) {
                    return false;
                }
                HgRc hgrc = new HgRc(ws);
                return this.canUpdate(hgrc);
            }

            private boolean canUpdate(HgRc ini) {
                String upstream = ini.getSection("paths").get("default");
                if (upstream == null) {
                    return false;
                }
                if (upstream.equals(MercurialSCM.this.source)) {
                    return true;
                }
                if ((upstream + '/').equals(MercurialSCM.this.source)) {
                    return true;
                }
                if (MercurialSCM.this.source.startsWith("file:/") && new File(upstream).toURI().toString().equals(MercurialSCM.this.source)) {
                    return true;
                }
                listener.error("Workspace reports paths.default as " + upstream + "\nwhich looks different than " + MercurialSCM.this.source + "\nso falling back to fresh clone rather than incremental update");
                return false;
            }
        });
        if (canUpdate) {
            return this.update(build, launcher, workspace, listener, changelogFile);
        }
        return this.clone(build, launcher, workspace, listener, changelogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException, IOException {
        int r;
        if (this.clean) {
            if (launcher.launch().cmds(new String[]{this.findHgExe((TaskListener)listener), "update", "-C", "."}).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((TaskListener)listener).pwd(workspace).join() != 0) {
                listener.error("Failed to clobber local modifications");
                return false;
            }
            if (launcher.launch().cmds(new String[]{this.findHgExe((TaskListener)listener), "--config", "extensions.purge=", "clean", "--all"}).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((TaskListener)listener).pwd(workspace).join() != 0) {
                listener.error("Failed to clean unversioned files");
                return false;
            }
        }
        FilePath hgBundle = new FilePath(workspace, "hg.bundle");
        hgBundle.delete();
        FileOutputStream os = new FileOutputStream(changelogFile);
        os.write("<changesets>\n".getBytes());
        try {
            String template;
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{this.findHgExe((TaskListener)listener), "incoming", "--quiet", "--bundle", "hg.bundle"});
            if (this.isHg10orLater()) {
                template = "<changeset node='{node}' author='{author|xmlescape}' rev='{rev}' date='{date}'><msg>{desc|xmlescape}</msg><added>{file_adds|stringify|xmlescape}</added><deleted>{file_dels|stringify|xmlescape}</deleted><files>{files|stringify|xmlescape}</files><parents>{parents}</parents></changeset>\\n";
            } else {
                template = "<changeset node='{node}' author='{author|escape}' rev='{rev}' date='{date}'><msg>{desc|escape}</msg><added>{file_adds|stringify|escape}</added><deleted>{file_dels|stringify|escape}</deleted><files>{files|stringify|escape}</files><parents>{parents}</parents></changeset>\\n";
                args.add("--debug");
            }
            args.add(new String[]{"--template", template});
            args.add(new String[]{"-r", this.getBranch()});
            ByteArrayOutputStream errorLog = new ByteArrayOutputStream();
            WriterOutputStream o = new WriterOutputStream((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"));
            try {
                r = launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((OutputStream)new ForkOutputStream((OutputStream)o, (OutputStream)errorLog)).pwd(workspace).join();
            }
            finally {
                o.flush();
            }
            if (r != 0 && r != 1) {
                Util.copyStream((InputStream)new ByteArrayInputStream(errorLog.toByteArray()), (OutputStream)listener.getLogger());
                listener.error("Failed to determine incoming changes");
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            listener.error("Failed to pull");
            boolean bl = false;
            return bl;
        }
        finally {
            os.write("</changesets>".getBytes());
            os.close();
        }
        if (r == 0 && hgBundle.exists()) {
            try {
                if (launcher.launch().cmds(new String[]{this.findHgExe((TaskListener)listener), "pull", "hg.bundle"}).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((TaskListener)listener).pwd(workspace).join() != 0) {
                    listener.error("Failed to pull");
                    return false;
                }
                if (launcher.launch().cmds(new String[]{this.findHgExe((TaskListener)listener), "up", "-C", "-r", this.getBranch()}).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((TaskListener)listener).pwd(workspace).join() != 0) {
                    listener.error("Failed to update");
                    return false;
                }
            }
            catch (IOException e) {
                listener.error("Failed to pull");
                return false;
            }
        }
        hgBundle.delete();
        this.addTagActionToBuild(build, launcher, workspace, listener);
        return true;
    }

    private void addTagActionToBuild(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) throws IOException, InterruptedException {
        ByteArrayOutputStream rev = new ByteArrayOutputStream();
        if (launcher.launch().cmds(new String[]{this.findHgExe((TaskListener)listener), "log", "-r", ".", "--template", "{node}"}).pwd(workspace).stdout((OutputStream)rev).join() != 0) {
            listener.error("Failed to id");
            listener.getLogger().write(rev.toByteArray());
            throw new AbortException();
        }
        String id = rev.toString();
        if (!REVISIONID_PATTERN.matcher(id).matches()) {
            listener.error("Expected to get an id but got " + id + " instead.");
            throw new AbortException();
        }
        build.addAction((Action)new MercurialTagAction(id));
    }

    private boolean isHg10orLater() {
        boolean hg10 = false;
        try {
            String v = this.getDescriptor().findHgVersion();
            try {
                if (v != null && new VersionNumber(v).compareTo(new VersionNumber("1.0")) >= 0) {
                    hg10 = true;
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.INFO, "Failed to parse Mercurial version number: " + v, e);
            }
        }
        catch (IOException x) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return hg10;
    }

    private boolean clone(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException, IOException {
        try {
            workspace.deleteRecursive();
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clean the workspace"));
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.findHgExe((TaskListener)listener), "clone"});
        args.add(new String[]{"-r", this.getBranch()});
        args.add(new String[]{this.source, workspace.getRemote()});
        try {
            if (launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((TaskListener)listener).join() != 0) {
                listener.error("Failed to clone " + this.source);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clone " + this.source));
            return false;
        }
        this.addTagActionToBuild(build, launcher, workspace, listener);
        return this.createEmptyChangeLog(changelogFile, listener, "changelog");
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        MercurialTagAction a = (MercurialTagAction)build.getAction(MercurialTagAction.class);
        if (a != null) {
            env.put("MERCURIAL_REVISION", a.id);
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new MercurialChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getModules() {
        return this.modules;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends SCMDescriptor<MercurialSCM> {
        private String hgExe;
        private transient String version;
        private static final Pattern VERSION_STRING = Pattern.compile("\\(version ([0-9.]+)");

        public DescriptorImpl() {
            super(HgBrowser.class);
            this.load();
        }

        protected DescriptorImpl(Class<MercurialSCM> clazz, Class<? extends RepositoryBrowser> repositoryBrowser) {
            super(clazz, repositoryBrowser);
        }

        public String getDisplayName() {
            return "Mercurial";
        }

        public String getHgExe() {
            if (this.hgExe == null) {
                return "hg";
            }
            return this.hgExe;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (SCM)super.newInstance(req, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.hgExe = req.getParameter("mercurial.hgExe");
            this.version = null;
            this.save();
            return true;
        }

        private String findHgVersion() throws IOException, InterruptedException {
            return this.findHgVersion(VERSION_STRING);
        }

        private String findHgVersion(Pattern p) throws IOException, InterruptedException {
            if (this.version != null) {
                return this.version;
            }
            ByteBuffer baos = new ByteBuffer();
            Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch().cmds(new String[]{this.getHgExe(), "version"}).stdout((OutputStream)baos).start();
            proc.join();
            Matcher m = p.matcher(baos.toString());
            if (m.find()) {
                this.version = m.group(1);
                return this.version;
            }
            return null;
        }
    }
}

