/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.MercurialChangeLogParser;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialSCM
extends SCM
implements Serializable {
    private final String source;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public MercurialSCM(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        String remoteTip = this.getTipRevision(launcher, workspace, listener);
        PrintStream output = listener.getLogger();
        if (launcher.launch(new String[]{this.getDescriptor().getHgExe(), "id", "-r", remoteTip}, EnvVars.masterEnvVars, (OutputStream)output, workspace).join() == 0) {
            output.println("No changes");
            return false;
        }
        output.println("Changes detected");
        return true;
    }

    private String getTipRevision(Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (launcher.launch(new String[]{this.getDescriptor().getHgExe(), "id", "default"}, EnvVars.masterEnvVars, (OutputStream)baos, workspace).join() != 0) {
            listener.error("Failed to check the tip revision");
            throw new AbortException();
        }
        return new String(baos.toByteArray(), "ASCII").trim();
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean canUpdate = (Boolean)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        if (canUpdate) {
            return this.update(build, launcher, workspace, listener, changelogFile);
        }
        return this.clone(build, launcher, workspace, listener, changelogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException, IOException {
        int r;
        FileOutputStream os = new FileOutputStream(changelogFile);
        os.write("<changesets>\n".getBytes());
        try {
            r = launcher.launch(new String[]{this.getDescriptor().getHgExe(), "incoming", "--quiet", "--bundle", "hg.bundle", "--template", "<changeset node='{node}' author='{author}' rev='{rev}' date='{date}'><msg>{desc|escape}</msg><added>{files_added}</added><deleted>{file_dels}</deleted><files>{files}</files></changeset>\\n"}, build.getEnvVars(), (OutputStream)os, workspace).join();
            if (r != 0 && r != 1) {
                listener.error("Failed to determine incoming changes");
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            listener.error("Failed to pull");
            boolean bl = false;
            return bl;
        }
        finally {
            os.write("</changesets>".getBytes());
            os.close();
        }
        if (r == 0 && new FilePath(workspace, "hg.bundle").exists()) {
            try {
                if (launcher.launch(new String[]{this.getDescriptor().getHgExe(), "pull", "-u", "hg.bundle"}, build.getEnvVars(), (OutputStream)listener.getLogger(), workspace).join() != 0) {
                    listener.error("Failed to pull");
                    return false;
                }
            }
            catch (IOException e) {
                listener.error("Failed to pull");
                return false;
            }
        }
        return true;
    }

    private boolean clone(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException {
        try {
            workspace.deleteRecursive();
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clean the workspace"));
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getDescriptor().getHgExe(), "clone", this.source, workspace.getRemote()});
        try {
            if (launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)listener.getLogger(), null).join() != 0) {
                listener.error("Failed to clone " + this.source);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clone " + this.source));
            return false;
        }
        return this.createEmptyChangeLog(changelogFile, listener, "changelog");
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
    }

    public ChangeLogParser createChangeLogParser() {
        return new MercurialChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    static /* synthetic */ String access$000(MercurialSCM x0) {
        return x0.source;
    }
}

