/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
class Cacher {
    private static final Map<String, ReentrantLock> locks = new HashMap();
    private static final Map<Node, Map<List<String>, Boolean>> supportsHg15Syntax = new WeakHashMap();

    private Cacher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String repositoryCache(MercurialSCM config, Node node, String remote, Launcher launcher, TaskListener listener, boolean fromPolling) throws IOException, InterruptedException {
        ReentrantLock lock;
        String hashSource = Cacher.hashSource((String)remote);
        Map map = locks;
        synchronized (map) {
            lock = (ReentrantLock)locks.get(hashSource);
            if (lock == null) {
                lock = new ReentrantLock(true);
                locks.put(hashSource, lock);
            }
        }
        boolean wasLocked = lock.isLocked();
        if (wasLocked) {
            listener.getLogger().println("Waiting for lock on hgcache/" + hashSource + "...");
        }
        lock.lockInterruptibly();
        try {
            String string;
            Launcher masterLauncher;
            if (wasLocked) {
                listener.getLogger().println("...acquired cache lock.");
            }
            Hudson master = Hudson.getInstance();
            FilePath masterCaches = master.getRootPath().child("hgcache");
            FilePath masterCache = masterCaches.child(hashSource);
            String masterCacheS = masterCache.getRemote();
            Launcher launcher2 = masterLauncher = node == master ? launcher : master.createLauncher(listener);
            if (masterCache.isDirectory()) {
                if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)MercurialSCM.launch((Launcher)masterLauncher).cmds(config.findHgExe((Node)master, listener, true).add("pull")).pwd(masterCache).stdout(listener), (boolean)fromPolling, (TaskListener)listener) != 0) {
                    listener.error("Failed to update " + masterCache);
                    String string2 = null;
                    return string2;
                }
            } else {
                masterCaches.mkdirs();
                if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)MercurialSCM.launch((Launcher)masterLauncher).cmds(config.findHgExe((Node)master, listener, true).add(new String[]{"clone", "--noupdate", remote, masterCacheS})).stdout(listener), (boolean)fromPolling, (TaskListener)listener) != 0) {
                    listener.error("Failed to clone " + remote);
                    String string3 = null;
                    return string3;
                }
            }
            if (node == master) {
                String string4 = masterCacheS;
                return string4;
            }
            FilePath localCaches = node.getRootPath().child("hgcache");
            FilePath localCache = localCaches.child(hashSource);
            FilePath masterTransfer = masterCache.child("xfer.hg");
            FilePath localTransfer = localCache.child("xfer.hg");
            try {
                if (localCache.isDirectory()) {
                    Set masterHeads = Cacher.headsOf((FilePath)masterCache, (MercurialSCM)config, (Node)master, (Launcher)masterLauncher, (TaskListener)listener, (boolean)fromPolling);
                    Set localHeads = Cacher.headsOf((FilePath)localCache, (MercurialSCM)config, (Node)node, (Launcher)launcher, (TaskListener)listener, (boolean)fromPolling);
                    if (((Object)localHeads).equals(masterHeads)) {
                        listener.getLogger().println("Local cache is up to date.");
                    } else {
                        ArgumentListBuilder args = config.findHgExe((Node)master, listener, true).add("bundle");
                        for (String head : localHeads) {
                            args.add(new String[]{"--base", head});
                        }
                        args.add("xfer.hg");
                        if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)MercurialSCM.launch((Launcher)masterLauncher).cmds(args).pwd(masterCache).stdout(listener), (boolean)fromPolling, (TaskListener)listener) != 0) {
                            listener.error("Failed to send outgoing changes");
                            String string5 = null;
                            return string5;
                        }
                    }
                } else {
                    if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)MercurialSCM.launch((Launcher)masterLauncher).cmds(config.findHgExe((Node)master, listener, true).add(new String[]{"bundle", "--all", "xfer.hg"})).pwd(masterCache).stdout(listener), (boolean)fromPolling, (TaskListener)listener) != 0) {
                        listener.error("Failed to bundle repo");
                        String string6 = null;
                        return string6;
                    }
                    localCaches.mkdirs();
                    if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)MercurialSCM.launch((Launcher)launcher).cmds(config.findHgExe(node, listener, true).add(new String[]{"init", localCache.getRemote()})).stdout(listener), (boolean)fromPolling, (TaskListener)listener) != 0) {
                        listener.error("Failed to create local cache");
                        String string7 = null;
                        return string7;
                    }
                }
                if (masterTransfer.exists()) {
                    masterTransfer.copyTo(localTransfer);
                    if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)MercurialSCM.launch((Launcher)launcher).cmds(config.findHgExe(node, listener, true).add(new String[]{"unbundle", "xfer.hg"})).pwd(localCache).stdout(listener), (boolean)fromPolling, (TaskListener)listener) != 0) {
                        listener.error("Failed to unbundle " + localTransfer);
                        string = null;
                        return string;
                    }
                }
            }
            finally {
                masterTransfer.delete();
                localTransfer.delete();
            }
            string = localCache.getRemote();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private static Set<String> headsOf(FilePath repo, MercurialSCM config, Node node, Launcher launcher, TaskListener listener, boolean fromPolling) throws IOException, InterruptedException {
        String output;
        Boolean using15Syntax;
        List hgConfig = config.findHgExe(node, listener, false).toList();
        HashMap<List, Boolean> supportsHg15SyntaxForNode = (HashMap<List, Boolean>)supportsHg15Syntax.get(node);
        if (supportsHg15SyntaxForNode == null) {
            supportsHg15SyntaxForNode = new HashMap<List, Boolean>();
            supportsHg15Syntax.put(node, supportsHg15SyntaxForNode);
        }
        if ((using15Syntax = (Boolean)supportsHg15SyntaxForNode.get(hgConfig)) == null) {
            try {
                output = Cacher.runHeadsCommand((FilePath)repo, (MercurialSCM)config, (Node)node, (Launcher)launcher, (TaskListener)listener, (boolean)fromPolling, (boolean)true);
                supportsHg15SyntaxForNode.put(hgConfig, true);
            }
            catch (AbortException x) {
                output = Cacher.runHeadsCommand((FilePath)repo, (MercurialSCM)config, (Node)node, (Launcher)launcher, (TaskListener)listener, (boolean)fromPolling, (boolean)false);
                supportsHg15SyntaxForNode.put(hgConfig, false);
            }
        } else {
            output = using15Syntax != false ? Cacher.runHeadsCommand((FilePath)repo, (MercurialSCM)config, (Node)node, (Launcher)launcher, (TaskListener)listener, (boolean)fromPolling, (boolean)true) : Cacher.runHeadsCommand((FilePath)repo, (MercurialSCM)config, (Node)node, (Launcher)launcher, (TaskListener)listener, (boolean)fromPolling, (boolean)false);
        }
        LinkedHashSet<String> heads = new LinkedHashSet<String>(Arrays.asList(output.split("\n")));
        heads.remove("");
        return heads;
    }

    private static String runHeadsCommand(FilePath repo, MercurialSCM config, Node node, Launcher launcher, TaskListener listener, boolean fromPolling, boolean usingHg15Syntax) throws IOException, InterruptedException {
        if (usingHg15Syntax) {
            return config.runHgAndCaptureOutput(node, launcher, repo, listener, fromPolling, new String[]{"heads", "--template", "{node}\\n", "--topo", "--closed"});
        }
        return config.runHgAndCaptureOutput(node, launcher, repo, listener, fromPolling, new String[]{"heads", "--template", "{node}\\n"});
    }

    static String hashSource(String source) {
        BigInteger hash;
        if (!source.endsWith("/")) {
            source = source + "/";
        }
        Matcher m = Pattern.compile(".+[/]([^/]+)[/]?").matcher(source);
        try {
            hash = new BigInteger(1, MessageDigest.getInstance("SHA-1").digest(source.getBytes("UTF-8")));
        }
        catch (Exception x) {
            throw new AssertionError((Object)x);
        }
        return String.format("%040X%s", hash, m.matches() ? "-" + m.group(1) : "");
    }
}

