/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class HgWeb
extends HgBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public HgWeb(String url) throws MalformedURLException {
        super(url);
    }

    public URL getChangeSetLink(MercurialChangeSet changeSet) throws IOException {
        this.current = changeSet;
        return new URL(this.getUrl(), "rev/" + changeSet.getShortNode());
    }

    public URL getFileLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        return new URL(this.getUrl(), "file/" + this.current.getShortNode() + "/" + path);
    }

    public URL getDiffLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        return new URL(this.getUrl(), "diff/" + this.current.getShortNode() + "/" + path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "hgweb";
        }

        public HgWeb newInstance(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            return (HgWeb)((Object)req.bindParameters(HgWeb.class, "hgweb."));
        }
    }
}

