/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgExe {
    private final ArgumentListBuilder base;
    private final EnvVars env;
    public final Launcher launcher;
    public final Node node;
    public final TaskListener listener;
    private final Capability capability;
    private static final Pattern REVISIONID_PATTERN = Pattern.compile("[0-9a-f]{40}");

    public HgExe(MercurialSCM scm, Launcher launcher, AbstractBuild build, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        this(scm, launcher, build.getBuiltOn(), listener, env);
    }

    public HgExe(MercurialSCM scm, Launcher launcher, Node node, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        this.base = scm.findHgExe(node, listener, true);
        this.node = node;
        this.env = env;
        this.launcher = launcher;
        this.listener = listener;
        this.capability = Capability.get(this);
    }

    private Launcher.ProcStarter l(ArgumentListBuilder args) {
        return MercurialSCM.launch(this.launcher).cmds(args).stdout(this.listener);
    }

    private ArgumentListBuilder seed() {
        return this.base.clone();
    }

    public Launcher.ProcStarter pull() {
        return this.run("pull");
    }

    public Launcher.ProcStarter clone(String ... args) {
        return this.l(this.seed().add("clone").add(args));
    }

    public Launcher.ProcStarter bundleAll(String file) {
        return this.run("bundle", "--all", file);
    }

    public Launcher.ProcStarter bundle(Collection<String> bases, String file) {
        ArgumentListBuilder args = this.seed().add("bundle");
        for (String head : bases) {
            args.add(new String[]{"--base", head});
        }
        args.add(file);
        return this.l(args);
    }

    public Launcher.ProcStarter init(FilePath path) {
        return this.run("init", path.getRemote());
    }

    public Launcher.ProcStarter unbundle(String bundleFile) {
        return this.run("unbundle", bundleFile);
    }

    public Launcher.ProcStarter cleanAll() {
        return this.run("--config", "extensions.purge=", "clean", "--all");
    }

    public Launcher.ProcStarter run(String ... args) {
        return this.l(this.seed().add(args));
    }

    public Launcher.ProcStarter run(ArgumentListBuilder args) {
        return this.l(this.seed().add(args.toCommandArray()));
    }

    public Set<String> heads(FilePath repo, boolean useTimeout) throws IOException, InterruptedException {
        if (this.capability.headsIn15 == null) {
            try {
                Set<String> output = this.heads(repo, useTimeout, true);
                this.capability.headsIn15 = true;
                return output;
            }
            catch (AbortException x) {
                Set<String> output = this.heads(repo, useTimeout, false);
                this.capability.headsIn15 = false;
                return output;
            }
        }
        return this.heads(repo, useTimeout, this.capability.headsIn15);
    }

    private Set<String> heads(FilePath repo, boolean useTimeout, boolean usingHg15Syntax) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"heads", "--template", "{node}\\n"});
        if (usingHg15Syntax) {
            args.add(new String[]{"--topo", "--closed"});
        }
        String output = this.popen(repo, this.listener, useTimeout, args);
        LinkedHashSet<String> heads = new LinkedHashSet<String>(Arrays.asList(output.split("\n")));
        heads.remove("");
        return heads;
    }

    public String tip(FilePath repository) throws IOException, InterruptedException {
        String id = this.popen(repository, this.listener, false, new ArgumentListBuilder(new String[]{"log", "--rev", ".", "--template", "{node}"}));
        if (!REVISIONID_PATTERN.matcher(id).matches()) {
            this.listener.error("Expected to get an id but got " + id + " instead.");
            throw new AbortException();
        }
        return id;
    }

    public List<String> toArgList() {
        return this.base.toList();
    }

    public String popen(FilePath repository, TaskListener listener, boolean useTimeout, ArgumentListBuilder args) throws IOException, InterruptedException {
        args = this.seed().add(args.toCommandArray());
        ByteArrayOutputStream rev = new ByteArrayOutputStream();
        if (MercurialSCM.joinWithPossibleTimeout(this.l(args).pwd(repository).stdout((OutputStream)rev), useTimeout, listener) == 0) {
            return rev.toString();
        }
        listener.error("Failed to run " + args.toStringWithQuote());
        listener.getLogger().write(rev.toByteArray());
        throw new AbortException();
    }

    private static final class Capability {
        volatile Boolean headsIn15;
        private static final Map<Node, Map<List<String>, Capability>> MAP = new WeakHashMap<Node, Map<List<String>, Capability>>();

        private Capability() {
        }

        static synchronized Capability get(HgExe hg) {
            List<String> hgConfig;
            Capability cap;
            Map<List<String>, Capability> m = MAP.get(hg.node);
            if (m == null) {
                m = new HashMap<List<String>, Capability>();
                MAP.put(hg.node, m);
            }
            if ((cap = m.get(hgConfig = hg.toArgList())) == null) {
                cap = new Capability();
                m.put(hgConfig, cap);
            }
            return cap;
        }
    }
}

