/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.HgExe;
import hudson.plugins.mercurial.MercurialSCM;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
class Cache {
    private final String remote;
    private final String hash;
    private final ReentrantLock lock = new ReentrantLock(true);
    private static final Map<String, Cache> CACHES = new HashMap();

    private Cache(String remote, String hash) {
        this.remote = remote;
        this.hash = hash;
    }

    public static synchronized Cache fromURL(String remote) {
        String h = Cache.hashSource((String)remote);
        Cache cache = (Cache)CACHES.get(h);
        if (cache == null) {
            cache = new Cache(remote, h);
            CACHES.put(h, cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FilePath repositoryCache(MercurialSCM config, Node node, Launcher launcher, TaskListener listener, boolean fromPolling) throws IOException, InterruptedException {
        boolean wasLocked = this.lock.isLocked();
        if (wasLocked) {
            listener.getLogger().println("Waiting for lock on hgcache/" + this.hash + "...");
        }
        this.lock.lockInterruptibly();
        try {
            if (wasLocked) {
                listener.getLogger().println("...acquired cache lock.");
            }
            Hudson master = Hudson.getInstance();
            FilePath masterCaches = master.getRootPath().child("hgcache");
            FilePath masterCache = masterCaches.child(this.hash);
            Launcher masterLauncher = node == master ? launcher : master.createLauncher(listener);
            HgExe masterHg = new HgExe(config, masterLauncher, (Node)master, listener, new EnvVars());
            if (masterCache.isDirectory()) {
                if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)masterHg.pull().pwd(masterCache), (boolean)fromPolling, (TaskListener)listener) != 0) {
                    listener.error("Failed to update " + masterCache);
                    FilePath filePath = null;
                    return filePath;
                }
            } else {
                masterCaches.mkdirs();
                if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)masterHg.clone(new String[]{"--noupdate", this.remote, masterCache.getRemote()}), (boolean)fromPolling, (TaskListener)listener) != 0) {
                    listener.error("Failed to clone " + this.remote);
                    FilePath filePath = null;
                    return filePath;
                }
            }
            if (node == master) {
                FilePath filePath = masterCache;
                return filePath;
            }
            FilePath localCaches = node.getRootPath().child("hgcache");
            FilePath localCache = localCaches.child(this.hash);
            FilePath masterTransfer = masterCache.child("xfer.hg");
            FilePath localTransfer = localCache.child("xfer.hg");
            try {
                HgExe slaveHg = new HgExe(config, launcher, node, listener, new EnvVars());
                if (localCache.isDirectory()) {
                    Set masterHeads = masterHg.heads(masterCache, fromPolling);
                    Set localHeads = slaveHg.heads(localCache, fromPolling);
                    if (((Object)localHeads).equals(masterHeads)) {
                        listener.getLogger().println("Local cache is up to date.");
                    } else if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)masterHg.bundle((Collection)localHeads, "xfer.hg").pwd(masterCache), (boolean)fromPolling, (TaskListener)listener) != 0) {
                        listener.error("Failed to send outgoing changes");
                        FilePath filePath = null;
                        return filePath;
                    }
                } else {
                    if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)masterHg.bundleAll("xfer.hg").pwd(masterCache), (boolean)fromPolling, (TaskListener)listener) != 0) {
                        listener.error("Failed to bundle repo");
                        FilePath filePath = null;
                        return filePath;
                    }
                    localCaches.mkdirs();
                    if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)slaveHg.init(localCache), (boolean)fromPolling, (TaskListener)listener) != 0) {
                        listener.error("Failed to create local cache");
                        FilePath filePath = null;
                        return filePath;
                    }
                }
                if (masterTransfer.exists()) {
                    masterTransfer.copyTo(localTransfer);
                    if (MercurialSCM.joinWithPossibleTimeout((Launcher.ProcStarter)slaveHg.unbundle("xfer.hg").pwd(localCache), (boolean)fromPolling, (TaskListener)listener) != 0) {
                        listener.error("Failed to unbundle " + localTransfer);
                        FilePath filePath = null;
                        return filePath;
                    }
                }
            }
            finally {
                masterTransfer.delete();
                localTransfer.delete();
            }
            FilePath filePath = localCache;
            return filePath;
        }
        finally {
            this.lock.unlock();
        }
    }

    static String hashSource(String source) {
        BigInteger hash;
        if (!source.endsWith("/")) {
            source = source + "/";
        }
        Matcher m = Pattern.compile(".+[/]([^/]+)[/]?").matcher(source);
        try {
            hash = new BigInteger(1, MessageDigest.getInstance("SHA-1").digest(source.getBytes("UTF-8")));
        }
        catch (Exception x) {
            throw new AssertionError((Object)x);
        }
        return String.format("%040X%s", hash, m.matches() ? "-" + m.group(1) : "");
    }
}

