/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.browser.HgBrowser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.kohsuke.stapler.DataBoundConstructor;

public class GoogleCode
extends HgBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GoogleCode(String url) throws MalformedURLException {
        super(url);
        if (!this.getUrl().toExternalForm().endsWith("/source/")) {
            throw new MalformedURLException("GoogleCode browser URL (currently: " + url + ") must end with '/source/'");
        }
    }

    public URL getChangeSetLink(MercurialChangeSet changeSet) throws IOException {
        this.current = changeSet;
        return new URL(this.getUrl(), "detail?r=" + changeSet.getNode());
    }

    public URL getFileLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        return new URL(this.getUrl(), "browse/" + path + "?spec=svn" + this.current.getNode() + "&r=" + this.current.getNode());
    }

    public URL getDiffLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        try {
            return new URL(this.getUrl(), "diff?spec=svn" + this.current.getNode() + "&r=" + this.current.getNode() + "&format=unidiff&path=%2F" + URLEncoder.encode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JDK broken?", e);
        }
    }
}

