/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.AbstractBuild;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.MercurialChangeSetList;
import hudson.scm.ChangeLogParser;
import hudson.util.Digester2;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialChangeLogParser
extends ChangeLogParser {
    private final Set<String> modules;

    public MercurialChangeLogParser(Set<String> modules) {
        this.modules = modules;
    }

    public MercurialChangeSetList parse(AbstractBuild build, File changelogFile) throws IOException, SAXException {
        Digester2 digester = new Digester2();
        ArrayList<MercurialChangeSet> r = new ArrayList<MercurialChangeSet>();
        digester.push(r);
        digester.addObjectCreate("*/changeset", MercurialChangeSet.class);
        digester.addSetProperties("*/changeset");
        digester.addSetProperties("*/changeset", "author", "user");
        digester.addBeanPropertySetter("*/changeset/msg");
        digester.addBeanPropertySetter("*/changeset/added");
        digester.addBeanPropertySetter("*/changeset/deleted");
        digester.addBeanPropertySetter("*/changeset/files");
        digester.addBeanPropertySetter("*/changeset/parents");
        digester.addSetNext("*/changeset", "add");
        try {
            digester.parse(changelogFile);
        }
        catch (IOException e) {
            throw new IOException2("Failed to parse " + changelogFile, (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOException2("Failed to parse " + changelogFile, (Throwable)e);
        }
        if (this.modules != null) {
            Iterator it = r.iterator();
            while (it.hasNext()) {
                boolean include = false;
                block4: for (String path : ((MercurialChangeSet)((Object)it.next())).getAffectedPaths()) {
                    for (String module : this.modules) {
                        if (!path.startsWith(module)) continue;
                        include = true;
                        break block4;
                    }
                }
                if (include) continue;
                it.remove();
            }
        }
        return new MercurialChangeSetList(build, r);
    }
}

