/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.model.User;
import hudson.plugins.mercurial.MercurialAffectedFile;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialChangeSet
extends ChangeLogSet.Entry {
    private String node;
    private String author;
    private long rev;
    private String date;
    private String msg;
    private boolean merge;
    private List<String> added = Collections.emptyList();
    private List<String> deleted = Collections.emptyList();
    private List<String> modified = Collections.emptyList();
    private volatile List<String> affectedPaths;
    static final String CHANGELOG_TEMPLATE = "<changeset node='{node}' author='{author|xmlescape}' rev='{rev}' date='{date}'><msg>{desc|xmlescape}</msg><added>{file_adds|stringify|xmlescape}</added><deleted>{file_dels|stringify|xmlescape}</deleted><files>{files|stringify|xmlescape}</files><parents>{parents}</parents></changeset>\\n";

    @Exported
    public String getMsg() {
        return this.msg;
    }

    @Exported
    public User getAuthor() {
        return User.get((String)this.author);
    }

    @Exported
    public String getNode() {
        return this.node;
    }

    public String getShortNode() {
        return this.node.substring(0, 12);
    }

    @Exported
    public long getRev() {
        return this.rev;
    }

    @Exported
    public String getDate() {
        return this.date;
    }

    public Collection<String> getAffectedPaths() {
        if (this.affectedPaths == null) {
            ArrayList r = new ArrayList(this.added.size() + this.modified.size() + this.deleted.size());
            r.addAll(this.added);
            r.addAll(this.modified);
            r.addAll(this.deleted);
            this.affectedPaths = r;
        }
        return this.affectedPaths;
    }

    public Collection<? extends ChangeLogSet.AffectedFile> getAffectedFiles() {
        ArrayList<MercurialAffectedFile> affected = new ArrayList<MercurialAffectedFile>(this.added.size() + this.modified.size() + this.deleted.size());
        for (EditType editType : EditType.ALL) {
            for (String path : this.getPaths(editType)) {
                affected.add(new MercurialAffectedFile(editType, path));
            }
        }
        return affected;
    }

    @Exported
    public List<String> getAddedPaths() {
        return this.added;
    }

    @Exported
    public List<String> getDeletedPaths() {
        return this.deleted;
    }

    @Exported
    public List<String> getModifiedPaths() {
        return this.modified;
    }

    @Exported
    public boolean isMerge() {
        return this.merge;
    }

    public List<String> getPaths(EditType kind) {
        if (kind == EditType.ADD) {
            return this.getAddedPaths();
        }
        if (kind == EditType.EDIT) {
            return this.getModifiedPaths();
        }
        if (kind == EditType.DELETE) {
            return this.getDeletedPaths();
        }
        return null;
    }

    public List<EditType> getEditTypes() {
        return Arrays.asList(EditType.ADD, EditType.EDIT, EditType.DELETE);
    }

    protected void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    @Deprecated
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Deprecated
    public void setNode(String node) {
        this.node = node;
    }

    @Deprecated
    public void setUser(String author) {
        this.author = author;
    }

    @Deprecated
    public String getUser() {
        return this.author;
    }

    @Deprecated
    public void setAuthor(String author) {
        this.author = author;
    }

    @Deprecated
    public void setRev(long rev) {
        this.rev = rev;
    }

    @Deprecated
    public void setDate(String date) {
        this.date = date;
    }

    @Deprecated
    public void setAdded(String list) {
        if (this.merge) {
            return;
        }
        this.added = this.toList(list);
    }

    @Deprecated
    public void setDeleted(String list) {
        if (this.merge) {
            return;
        }
        this.deleted = this.toList(list);
    }

    @Deprecated
    public void setFiles(String list) {
        if (this.merge) {
            return;
        }
        this.modified = this.toList(list);
        if (!this.added.isEmpty() || !this.deleted.isEmpty()) {
            this.modified = new ArrayList(this.modified);
            this.modified.removeAll(this.added);
            this.modified.removeAll(this.deleted);
        }
    }

    @Deprecated
    public void setParents(String parents) {
        boolean bl = this.merge = parents.indexOf(58) != parents.lastIndexOf(58) && !parents.contains("-1");
        if (this.merge) {
            this.added = Collections.emptyList();
            this.deleted = Collections.emptyList();
            this.modified = Collections.emptyList();
        }
    }

    private List<String> toList(String list) {
        if ((list = list.trim()).length() == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(list.split(" "));
    }
}

