/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.Cache;
import hudson.plugins.mercurial.HgExe;
import hudson.plugins.mercurial.HgRc;
import hudson.plugins.mercurial.MercurialChangeLogParser;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialTagAction;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.plugins.mercurial.browser.HgWeb;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.ArgumentListBuilder;
import hudson.util.ForkOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialSCM
extends SCM
implements Serializable {
    private final String installation;
    private final String source;
    private transient Set<String> _modules;
    private final String modules;
    private final String branch;
    private final String subdir;
    private final boolean clean;
    private final boolean forest;
    private HgBrowser browser;
    private static final String FILES_STYLE = "changeset = 'id:{node}\\nfiles:{files}\\n'\nfile = '{file}:'";
    private static Pattern FILES_LINE = Pattern.compile("files:(.*)");
    static boolean CACHE_LOCAL_REPOS = false;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MercurialSCM.class.getName());

    @DataBoundConstructor
    public MercurialSCM(String installation, String source, String branch, String modules, String subdir, HgBrowser browser, boolean clean, boolean forest) {
        this.installation = installation;
        this.source = source;
        this.modules = Util.fixNull((String)modules);
        this.subdir = Util.fixEmptyAndTrim((String)subdir);
        this.clean = clean;
        this.forest = forest;
        this.parseModules();
        branch = Util.fixEmpty((String)branch);
        if (branch != null && branch.equals("default")) {
            branch = null;
        }
        this.branch = branch;
        this.browser = browser;
    }

    private void parseModules() {
        if (this.modules.trim().length() > 0) {
            this._modules = new HashSet<String>();
            for (String r : this.modules.split("(?<!\\\\)[ \\r\\n,]+")) {
                if (r.length() == 0) continue;
                r = r.replaceAll("\\\\ ", " ");
                while (r.startsWith("/")) {
                    r = r.substring(1);
                }
                r = r.replace('\\', '/');
                this._modules.add(r);
            }
        } else {
            this._modules = null;
        }
    }

    private Object readResolve() {
        this.parseModules();
        return this;
    }

    public String getInstallation() {
        return this.installation;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch == null ? "default" : this.branch;
    }

    private String getBranch(EnvVars env) {
        return this.branch == null ? "default" : env.expand(this.branch);
    }

    public String getSubdir() {
        return this.subdir;
    }

    private FilePath workspace2Repo(FilePath workspace) {
        return this.subdir != null ? workspace.child(this.subdir) : workspace;
    }

    @SuppressWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    public HgBrowser getBrowser() {
        if (this.browser == null) {
            try {
                return new HgWeb(this.source);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.browser;
    }

    public boolean isClean() {
        return this.clean;
    }

    public boolean isForest() {
        return this.forest;
    }

    private ArgumentListBuilder findHgExe(AbstractBuild<?, ?> build, TaskListener listener, boolean allowDebug) throws IOException, InterruptedException {
        return this.findHgExe(build.getBuiltOn(), listener, allowDebug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArgumentListBuilder findHgExe(Node node, TaskListener listener, boolean allowDebug) throws IOException, InterruptedException {
        for (MercurialInstallation inst : MercurialInstallation.allInstallations()) {
            String downloadForest;
            if (!inst.getName().equals(this.installation)) continue;
            ArgumentListBuilder b = new ArgumentListBuilder(new String[]{inst.executableWithSubstitution(inst.forNode(node, listener).getHome())});
            if (this.forest && (downloadForest = inst.getDownloadForest()) != null) {
                FilePath forestPy = node.getRootPath().child(String.format("forest-%08X.py", downloadForest.hashCode()));
                if (!forestPy.exists()) {
                    listener.getLogger().println("Downloading: " + downloadForest);
                    InputStream is = new URL(downloadForest).openStream();
                    try {
                        forestPy.copyFrom(is);
                    }
                    finally {
                        is.close();
                    }
                }
                b.add(new String[]{"--config", "extensions.forest=" + forestPy.getRemote()});
            }
            if (allowDebug && inst.getDebug()) {
                b.add("--debug");
            }
            return b;
        }
        return new ArgumentListBuilder(new String[]{this.getDescriptor().getHgExe()});
    }

    static Launcher.ProcStarter launch(Launcher launcher) {
        return launcher.launch().envs(Collections.singletonMap("HGPLAIN", "true"));
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        HgExe hg = new HgExe(this, launcher, build, listener, build.getEnvironment(listener));
        String tip = hg.tip(this.workspace2Repo(build.getWorkspace()));
        return tip != null ? new MercurialTagAction(tip) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState _baseline) throws IOException, InterruptedException {
        MercurialTagAction baseline = (MercurialTagAction)_baseline;
        PrintStream output = listener.getLogger();
        HashSet<String> changedFileNames = new HashSet<String>();
        FilePath tmpFile = workspace.createTextTempFile("tmp", "style", FILES_STYLE);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AbstractProject<?, ?> _project = project;
            Node node = _project.getLastBuiltOn();
            ArgumentListBuilder cmd = this.findHgExe(node, listener, false);
            cmd.add(new String[]{this.forest ? "fincoming" : "incoming", "--style", tmpFile.getRemote()});
            cmd.add("--no-merges");
            cmd.add(new String[]{"--rev", this.getBranch()});
            cmd.add("--newest-first");
            String cachedSource = this.cachedSource(node, launcher, listener, true);
            if (cachedSource != null) {
                cmd.add(cachedSource);
            }
            MercurialSCM.joinWithPossibleTimeout(MercurialSCM.launch(launcher).cmds(cmd).stdout((OutputStream)new ForkOutputStream((OutputStream)baos, (OutputStream)output)).pwd(this.workspace2Repo(workspace)), true, listener);
            MercurialTagAction cur = this.parseIncomingOutput(baos, baseline, changedFileNames);
            PollingResult pollingResult = new PollingResult((SCMRevisionState)baseline, (SCMRevisionState)cur, this.computeDegreeOfChanges(changedFileNames, output));
            return pollingResult;
        }
        finally {
            tmpFile.delete();
        }
    }

    static int joinWithPossibleTimeout(Launcher.ProcStarter proc, boolean useTimeout, TaskListener listener) throws IOException, InterruptedException {
        return useTimeout ? proc.start().joinWithTimeout(3600L, TimeUnit.SECONDS, listener) : proc.join();
    }

    private PollingResult.Change computeDegreeOfChanges(Set<String> changedFileNames, PrintStream output) {
        LOGGER.log(Level.FINE, "Changed file names: {0}", changedFileNames);
        if (changedFileNames.isEmpty()) {
            return PollingResult.Change.NONE;
        }
        Set<String> depchanges = this.dependentChanges(changedFileNames);
        LOGGER.log(Level.FINE, "Dependent changed file names: {0}", depchanges);
        if (depchanges.isEmpty()) {
            output.println("Non-dependent changes detected");
            return PollingResult.Change.INSIGNIFICANT;
        }
        output.println("Dependent changes detected");
        return PollingResult.Change.SIGNIFICANT;
    }

    private Set<String> dependentChanges(Set<String> changedFileNames) {
        if (this._modules == null) {
            return changedFileNames;
        }
        HashSet<String> affecting = new HashSet<String>();
        block0: for (String changedFile : changedFileNames) {
            for (String dependency : this._modules) {
                if (!changedFile.startsWith(dependency)) continue;
                affecting.add(changedFile);
                continue block0;
            }
        }
        return affecting;
    }

    private MercurialTagAction parseIncomingOutput(ByteArrayOutputStream output, MercurialTagAction baseline, Set<String> result) throws IOException {
        String line;
        String headId = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.toByteArray())));
        while ((line = in.readLine()) != null) {
            Matcher matcher = FILES_LINE.matcher(line);
            if (matcher.matches()) {
                for (String s : matcher.group(1).split(":")) {
                    if (s.length() <= 0) continue;
                    result.add(s);
                }
            }
            if (!line.startsWith("id:")) continue;
            String id = line.substring(3);
            if (headId == null) {
                headId = id;
            }
            if (!id.equals(baseline.id)) continue;
            break;
        }
        if (headId == null) {
            return baseline;
        }
        return new MercurialTagAction(headId);
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, final BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean canUpdate = (Boolean)this.workspace2Repo(workspace).act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

            public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
                if (!HgRc.getHgRcFile(ws).exists()) {
                    return false;
                }
                HgRc hgrc = new HgRc(ws);
                return this.canUpdate(hgrc);
            }

            private boolean canUpdate(HgRc ini) {
                String upstream = ini.getSection("paths").get("default");
                if (upstream == null) {
                    return false;
                }
                if (upstream.equals(MercurialSCM.this.source)) {
                    return true;
                }
                if ((upstream + '/').equals(MercurialSCM.this.source)) {
                    return true;
                }
                if (upstream.equals(MercurialSCM.this.source + '/')) {
                    return true;
                }
                if (MercurialSCM.this.source.startsWith("file:/") && new File(upstream).toURI().toString().equals(MercurialSCM.this.source)) {
                    return true;
                }
                listener.error("Workspace reports paths.default as " + upstream + "\nwhich looks different than " + MercurialSCM.this.source + "\nso falling back to fresh clone rather than incremental update");
                return false;
            }
        });
        if (canUpdate) {
            return this.update(build, launcher, this.workspace2Repo(workspace), listener, changelogFile);
        }
        return this.clone(build, launcher, this.workspace2Repo(workspace), listener, changelogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(AbstractBuild<?, ?> build, Launcher launcher, FilePath repository, BuildListener listener, File changelogFile) throws InterruptedException, IOException {
        int r;
        String cachedSource;
        EnvVars env = build.getEnvironment((TaskListener)listener);
        HgExe hg = new HgExe(this, launcher, build, (TaskListener)listener, env);
        if (this.clean) {
            if (hg.run(this.forest ? "fupdate" : "update", "--clean", ".").pwd(repository).join() != 0) {
                listener.error("Failed to clobber local modifications");
                return false;
            }
            if (this.forest) {
                StringTokenizer trees = new StringTokenizer(hg.popen(repository, (TaskListener)listener, false, new ArgumentListBuilder(new String[]{"ftrees", "--convert"})));
                while (trees.hasMoreTokens()) {
                    String tree = trees.nextToken();
                    if (hg.cleanAll().pwd(tree.equals(".") ? repository : repository.child(tree)).join() == 0) continue;
                    listener.error("Failed to clean unversioned files in " + tree);
                    return false;
                }
            } else if (hg.cleanAll().pwd(repository).join() != 0) {
                listener.error("Failed to clean unversioned files");
                return false;
            }
        }
        FilePath hgBundle = new FilePath(repository, "hg.bundle");
        hgBundle.delete();
        FileOutputStream os = new FileOutputStream(changelogFile);
        try {
            block28: {
                boolean bl;
                try {
                    os.write("<changesets>\n".getBytes());
                    ArgumentListBuilder args = this.findHgExe(build, (TaskListener)listener, false);
                    args.add(new String[]{this.forest ? "fincoming" : "incoming", "--quiet"});
                    if (!this.forest) {
                        args.add(new String[]{"--bundle", "hg.bundle"});
                    }
                    args.add(new String[]{"--template", "<changeset node='{node}' author='{author|xmlescape}' rev='{rev}' date='{date}'><msg>{desc|xmlescape}</msg><added>{file_adds|stringify|xmlescape}</added><deleted>{file_dels|stringify|xmlescape}</deleted><files>{files|stringify|xmlescape}</files><parents>{parents}</parents></changeset>\\n"});
                    args.add(new String[]{"--rev", this.getBranch(env)});
                    cachedSource = this.cachedSource(build.getBuiltOn(), launcher, (TaskListener)listener, false);
                    if (cachedSource != null) {
                        args.add(cachedSource);
                    }
                    ByteArrayOutputStream errorLog = new ByteArrayOutputStream();
                    WriterOutputStream o = new WriterOutputStream((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"));
                    try {
                        r = MercurialSCM.launch(launcher).cmds(args).envs((Map)env).stdout((OutputStream)new ForkOutputStream((OutputStream)o, (OutputStream)errorLog)).pwd(repository).join();
                    }
                    finally {
                        o.flush();
                    }
                    if (r == 0 || r == 1) break block28;
                    Util.copyStream((InputStream)new ByteArrayInputStream(errorLog.toByteArray()), (OutputStream)listener.getLogger());
                    listener.error("Failed to determine incoming changes");
                    bl = false;
                }
                catch (IOException e) {
                    boolean bl2;
                    try {
                        listener.error("Failed to pull");
                        e.printStackTrace(listener.getLogger());
                        bl2 = false;
                    }
                    catch (Throwable throwable) {
                        os.write("</changesets>".getBytes());
                        throw throwable;
                    }
                    os.write("</changesets>".getBytes());
                    return bl2;
                }
                os.write("</changesets>".getBytes());
                return bl;
            }
            os.write("</changesets>".getBytes());
        }
        finally {
            os.close();
        }
        if (r == 0 && (hgBundle.exists() || this.forest)) {
            try {
                Launcher.ProcStarter ps = this.forest ? hg.run("fpull", "--rev", this.getBranch(env)) : hg.run("unbundle", "hg.bundle");
                if (ps.pwd(repository).join() != 0) {
                    listener.error("Failed to pull");
                    return false;
                }
                if (cachedSource != null && build.getNumber() % 100 == 0) {
                    hg.run("--config", "extensions.relink=", "relink", cachedSource).pwd(repository).join();
                }
                if (hg.run(this.forest ? "fupdate" : "update", "--clean", "--rev", this.getBranch(env)).pwd(repository).join() != 0) {
                    listener.error("Failed to update");
                    return false;
                }
            }
            catch (IOException e) {
                listener.error("Failed to pull");
                e.printStackTrace(listener.getLogger());
                return false;
            }
        }
        hgBundle.delete();
        String tip = hg.tip(repository);
        if (tip != null) {
            build.addAction((Action)new MercurialTagAction(tip));
        }
        return true;
    }

    private boolean clone(AbstractBuild<?, ?> build, Launcher launcher, FilePath repository, BuildListener listener, File changelogFile) throws InterruptedException, IOException {
        String tip;
        try {
            repository.deleteRecursive();
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clean the repository checkout"));
            return false;
        }
        EnvVars env = build.getEnvironment((TaskListener)listener);
        HgExe hg = new HgExe(this, launcher, build.getBuiltOn(), (TaskListener)listener, env);
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.forest ? "fclone" : "clone");
        args.add(new String[]{"--rev", this.getBranch(env)});
        String cachedSource = this.cachedSource(build.getBuiltOn(), launcher, (TaskListener)listener, false);
        if (cachedSource != null) {
            args.add(cachedSource);
        } else {
            args.add(this.source);
        }
        args.add(repository.getRemote());
        try {
            if (hg.run(args).join() != 0) {
                listener.error("Failed to clone " + this.source);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clone " + this.source));
            return false;
        }
        if (cachedSource != null) {
            FilePath hgrc = repository.child(".hg/hgrc");
            if (hgrc.exists()) {
                String hgrcText = hgrc.readToString();
                if (!hgrcText.contains(cachedSource)) {
                    listener.error(".hg/hgrc did not contain " + cachedSource + " as expected:\n" + hgrcText);
                    return false;
                }
                hgrc.write(hgrcText.replace(cachedSource, this.source), null);
            }
            hg.run("--config", "extensions.relink=", "relink", cachedSource).pwd(repository).join();
        }
        if ((tip = hg.tip(repository)) != null) {
            build.addAction((Action)new MercurialTagAction(tip));
        }
        return this.createEmptyChangeLog(changelogFile, listener, "changelog");
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        MercurialTagAction a = (MercurialTagAction)build.getAction(MercurialTagAction.class);
        if (a != null) {
            env.put("MERCURIAL_REVISION", a.id);
        }
    }

    public ChangeLogParser createChangeLogParser() {
        return new MercurialChangeLogParser(this._modules);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getModules() {
        return this.modules;
    }

    @CheckForNull
    private String cachedSource(Node node, Launcher launcher, TaskListener listener, boolean fromPolling) {
        if (!CACHE_LOCAL_REPOS && this.source.matches("(file:|[/\\\\]).+")) {
            return null;
        }
        if (this.forest) {
            return null;
        }
        boolean useCaches = false;
        for (MercurialInstallation inst : MercurialInstallation.allInstallations()) {
            if (!inst.getName().equals(this.installation)) continue;
            useCaches = inst.isUseCaches();
            break;
        }
        if (!useCaches) {
            return null;
        }
        try {
            FilePath cache = Cache.fromURL(this.source).repositoryCache(this, node, launcher, listener, fromPolling);
            if (cache != null) {
                return cache.getRemote();
            }
            listener.error("Failed to use repository cache for " + this.source);
            return null;
        }
        catch (Exception x) {
            x.printStackTrace(listener.error("Failed to use repository cache for " + this.source));
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends SCMDescriptor<MercurialSCM> {
        private String hgExe;

        public DescriptorImpl() {
            super(HgBrowser.class);
            this.load();
        }

        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return RepositoryBrowsers.filter(HgBrowser.class);
        }

        public String getDisplayName() {
            return "Mercurial";
        }

        public String getHgExe() {
            if (this.hgExe == null) {
                return "hg";
            }
            return this.hgExe;
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (SCM)super.newInstance(req, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.hgExe = req.getParameter("mercurial.hgExe");
            this.save();
            return true;
        }
    }
}

