/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.MercurialChangeLogParser;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.browser.HgWeb;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.util.ArgumentListBuilder;
import hudson.util.ForkOutputStream;
import hudson.util.WriterOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialSCM
extends SCM
implements Serializable {
    private final String source;
    private final String branch;
    private HgWeb browser;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public MercurialSCM(String source, String branch, HgWeb browser) {
        this.source = source;
        branch = Util.fixEmpty((String)branch);
        if (branch != null && branch.equals("default")) {
            branch = null;
        }
        this.branch = branch;
        this.browser = browser;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch;
    }

    public HgWeb getBrowser() {
        return this.browser;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        String remoteTip = this.getTipRevision(launcher, workspace, listener);
        PrintStream output = listener.getLogger();
        if (launcher.launch(new String[]{this.getDescriptor().getHgExe(), "id", "-r", remoteTip}, EnvVars.masterEnvVars, (OutputStream)output, workspace).join() == 0) {
            output.println("No changes");
            return false;
        }
        output.println("Changes detected");
        return true;
    }

    private String getTipRevision(Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getDescriptor().getHgExe(), "id"});
        if (this.branch != null) {
            args.add(new String[]{"-r", this.branch});
        }
        args.add("default");
        if (launcher.launch(args.toCommandArray(), EnvVars.masterEnvVars, (OutputStream)baos, workspace).join() != 0) {
            Util.copyStream((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)listener.getLogger());
            listener.error("Failed to check the tip revision");
            throw new AbortException();
        }
        return new String(baos.toByteArray(), "ASCII").trim();
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean canUpdate = (Boolean)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        if (canUpdate) {
            return this.update(build, launcher, workspace, listener, changelogFile);
        }
        return this.clone(build, launcher, workspace, listener, changelogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException, IOException {
        int r;
        FilePath hgBundle = new FilePath(workspace, "hg.bundle");
        hgBundle.delete();
        FileOutputStream os = new FileOutputStream(changelogFile);
        os.write("<changesets>\n".getBytes());
        try {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{this.getDescriptor().getHgExe(), "incoming", "--quiet", "--bundle", "hg.bundle"});
            args.add(new String[]{"--template", "<changeset node='{node}' author='{author|escape}' rev='{rev}' date='{date}'><msg>{desc|escape}</msg><added>{file_adds}</added><deleted>{file_dels}</deleted><files>{files}</files></changeset>\\n"});
            args.add("--debug");
            if (this.branch != null) {
                args.add(new String[]{"-r", this.branch});
            }
            ByteArrayOutputStream errorLog = new ByteArrayOutputStream();
            WriterOutputStream o = new WriterOutputStream((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"));
            try {
                r = launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)new ForkOutputStream((OutputStream)o, (OutputStream)errorLog), workspace).join();
            }
            finally {
                o.flush();
            }
            if (r != 0 && r != 1) {
                Util.copyStream((InputStream)new ByteArrayInputStream(errorLog.toByteArray()), (OutputStream)listener.getLogger());
                listener.error("Failed to determine incoming changes");
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            listener.error("Failed to pull");
            boolean bl = false;
            return bl;
        }
        finally {
            os.write("</changesets>".getBytes());
            os.close();
        }
        if (r == 0 && hgBundle.exists()) {
            try {
                if (launcher.launch(new String[]{this.getDescriptor().getHgExe(), "pull", "-u", "hg.bundle"}, build.getEnvVars(), (OutputStream)listener.getLogger(), workspace).join() != 0) {
                    listener.error("Failed to pull");
                    return false;
                }
            }
            catch (IOException e) {
                listener.error("Failed to pull");
                return false;
            }
        }
        return true;
    }

    private boolean clone(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException {
        try {
            workspace.deleteRecursive();
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clean the workspace"));
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getDescriptor().getHgExe(), "clone"});
        if (this.branch != null) {
            args.add(new String[]{"-r", this.branch});
        }
        args.add(new String[]{this.source, workspace.getRemote()});
        try {
            if (launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)listener.getLogger(), null).join() != 0) {
                listener.error("Failed to clone " + this.source);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clone " + this.source));
            return false;
        }
        return this.createEmptyChangeLog(changelogFile, listener, "changelog");
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
    }

    public ChangeLogParser createChangeLogParser() {
        return new MercurialChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    static /* synthetic */ String access$000(MercurialSCM x0) {
        return x0.source;
    }
}

