/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class HgRc {
    private final Map<String, Section> sections = new HashMap<String, Section>();
    private static final Pattern SECTION_HEADER = Pattern.compile("\\[(\\w+)\\].*");
    private static final Pattern KEY_VALUE = Pattern.compile("(\\w+)\\s*[=:]\\s*(\\S.*)");
    private static final Logger LOGGER = Logger.getLogger(HgRc.class.getName());
    private static final Section NULL = new Section();

    public HgRc(File workspace) throws IOException {
        String line;
        File hgrc = HgRc.getHgRcFile(workspace);
        if (!hgrc.exists()) {
            throw new IOException("No such file: " + hgrc);
        }
        BufferedReader r = new BufferedReader(new FileReader(hgrc));
        Section current = null;
        String key = null;
        String value = null;
        block5: while ((line = r.readLine()) != null) {
            Matcher m;
            if (line.length() == 0) continue;
            switch (line.charAt(0)) {
                case '#': 
                case ';': {
                    continue block5;
                }
                case '[': {
                    if (key != null) {
                        current.add(key, value);
                        key = null;
                    }
                    if (!(m = SECTION_HEADER.matcher(line)).matches()) {
                        LOGGER.warning("Failed to parse " + hgrc + " : " + line);
                        continue block5;
                    }
                    current = this.createSection(m.group(1));
                    continue block5;
                }
                case '\t': 
                case ' ': {
                    while (line.length() > 0 && Character.isWhitespace(line.charAt(0))) {
                        line = line.substring(1);
                    }
                    value = value + line;
                    continue block5;
                }
            }
            m = KEY_VALUE.matcher(line);
            if (!m.matches()) {
                LOGGER.warning("Failed to parse " + hgrc + " : " + line);
                continue;
            }
            if (key != null) {
                current.add(key, value);
            }
            key = m.group(1);
            value = m.group(2);
        }
        if (key != null) {
            current.add(key, value);
        }
    }

    public static File getHgRcFile(File workspace) {
        return new File(workspace, ".hg/hgrc");
    }

    private Section createSection(String name) {
        Section s = this.sections.get(name);
        if (s == null) {
            s = new Section();
            this.sections.put(name, s);
        }
        return s;
    }

    public Section getSection(String name) {
        Section s = this.sections.get(name);
        if (s == null) {
            s = NULL;
        }
        return s;
    }

    public static final class Section {
        private final Map<String, String> values = new HashMap<String, String>();

        public void add(String key, String value) {
            this.values.put(key, value);
        }

        public String get(String key) {
            return this.values.get(key);
        }
    }
}

