/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.HgRc;
import hudson.plugins.mercurial.MercurialChangeLogParser;
import hudson.plugins.mercurial.browser.HgWeb;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.ByteBuffer;
import hudson.util.ForkOutputStream;
import hudson.util.FormFieldValidator;
import hudson.util.VersionNumber;
import hudson.util.WriterOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialSCM
extends SCM
implements Serializable {
    private final String source;
    private final String branch;
    private HgWeb browser;
    private static final Pattern REVISION_PATTERN = Pattern.compile("[0-9A-Fa-f]{12}");
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public MercurialSCM(String source, String branch, HgWeb browser) {
        this.source = source;
        branch = Util.fixEmpty((String)branch);
        if (branch != null && branch.equals("default")) {
            branch = null;
        }
        this.branch = branch;
        this.browser = browser;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch;
    }

    public HgWeb getBrowser() {
        return this.browser;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        String remoteTip = this.getTipRevision(launcher, workspace, listener);
        PrintStream output = listener.getLogger();
        if (launcher.launch(new String[]{this.getDescriptor().getHgExe(), "id", "-r", remoteTip}, EnvVars.masterEnvVars, (OutputStream)output, workspace).join() == 0) {
            output.println("No changes");
            return false;
        }
        output.println("Changes detected");
        return true;
    }

    private String getTipRevision(Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getDescriptor().getHgExe(), "id"});
        if (this.branch != null) {
            args.add(new String[]{"-r", this.branch});
        }
        args.add("default");
        if (launcher.launch(args.toCommandArray(), EnvVars.masterEnvVars, (OutputStream)baos, workspace).join() != 0) {
            Util.copyStream((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)listener.getLogger());
            listener.error("Failed to check the tip revision");
            throw new AbortException();
        }
        String rev = null;
        for (String line : Util.tokenize((String)new String(baos.toByteArray(), "ASCII"), (String)"\r\n")) {
            if (!REVISION_PATTERN.matcher(line = line.trim()).matches()) continue;
            rev = line;
        }
        if (rev == null) {
            Util.copyStream((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)listener.getLogger());
            listener.error("Failed to identify a revision");
            throw new AbortException();
        }
        return rev;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean canUpdate = (Boolean)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

            public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
                if (!HgRc.getHgRcFile(ws).exists()) {
                    return false;
                }
                HgRc hgrc = new HgRc(ws);
                return this.canUpdate(hgrc);
            }

            private boolean canUpdate(HgRc ini) {
                String upstream = ini.getSection("paths").get("default");
                if (upstream == null) {
                    return false;
                }
                if (upstream.equals(MercurialSCM.this.source)) {
                    return true;
                }
                return MercurialSCM.this.source.startsWith("file:/") && new File(upstream).toURI().toString().equals(MercurialSCM.this.source);
            }
        });
        if (canUpdate) {
            return this.update(build, launcher, workspace, listener, changelogFile);
        }
        return this.clone(build, launcher, workspace, listener, changelogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException, IOException {
        int r;
        FilePath hgBundle = new FilePath(workspace, "hg.bundle");
        hgBundle.delete();
        FileOutputStream os = new FileOutputStream(changelogFile);
        os.write("<changesets>\n".getBytes());
        try {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{this.getDescriptor().getHgExe(), "incoming", "--quiet", "--bundle", "hg.bundle"});
            args.add(new String[]{"--template", "<changeset node='{node}' author='{author|escape}' rev='{rev}' date='{date}'><msg>{desc|escape}</msg><added>{file_adds}</added><deleted>{file_dels}</deleted><files>{files}</files><parents>{parents}</parents></changeset>\\n"});
            args.add("--debug");
            if (this.branch != null) {
                args.add(new String[]{"-r", this.branch});
            }
            ByteArrayOutputStream errorLog = new ByteArrayOutputStream();
            WriterOutputStream o = new WriterOutputStream((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"));
            try {
                r = launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)new ForkOutputStream((OutputStream)o, (OutputStream)errorLog), workspace).join();
            }
            finally {
                o.flush();
            }
            if (r != 0 && r != 1) {
                Util.copyStream((InputStream)new ByteArrayInputStream(errorLog.toByteArray()), (OutputStream)listener.getLogger());
                listener.error("Failed to determine incoming changes");
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            listener.error("Failed to pull");
            boolean bl = false;
            return bl;
        }
        finally {
            os.write("</changesets>".getBytes());
            os.close();
        }
        if (r == 0 && hgBundle.exists()) {
            try {
                if (launcher.launch(new String[]{this.getDescriptor().getHgExe(), "pull", "-u", "hg.bundle"}, build.getEnvVars(), (OutputStream)listener.getLogger(), workspace).join() != 0) {
                    listener.error("Failed to pull");
                    return false;
                }
            }
            catch (IOException e) {
                listener.error("Failed to pull");
                return false;
            }
        }
        hgBundle.delete();
        return true;
    }

    private boolean clone(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws InterruptedException {
        try {
            workspace.deleteRecursive();
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clean the workspace"));
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getDescriptor().getHgExe(), "clone"});
        if (this.branch != null) {
            args.add(new String[]{"-r", this.branch});
        }
        args.add(new String[]{this.source, workspace.getRemote()});
        try {
            if (launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)listener.getLogger(), null).join() != 0) {
                listener.error("Failed to clone " + this.source);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to clone " + this.source));
            return false;
        }
        return this.createEmptyChangeLog(changelogFile, listener, "changelog");
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
    }

    public ChangeLogParser createChangeLogParser() {
        return new MercurialChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends SCMDescriptor<MercurialSCM> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private String hgExe;
        private static final Pattern VERSION_STRING = Pattern.compile("\\(version ([0-9.]+)");
        private static final VersionNumber V0_9_4 = new VersionNumber("0.9.4");

        private DescriptorImpl() {
            super(MercurialSCM.class, HgWeb.class);
            this.load();
        }

        public String getDisplayName() {
            return "Mercurial";
        }

        public String getHgExe() {
            if (this.hgExe == null) {
                return "hg";
            }
            return this.hgExe;
        }

        public SCM newInstance(StaplerRequest req) throws Descriptor.FormException {
            return new MercurialSCM(req.getParameter("mercurial.source"), req.getParameter("mercurial.branch"), (HgWeb)RepositoryBrowsers.createInstance(HgWeb.class, (StaplerRequest)req, (String)"mercurial.browser"));
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.hgExe = req.getParameter("mercurial.hgExe");
            this.save();
            return true;
        }

        public void doHgExeCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.Executable(req, rsp){

                protected void checkExecutable(File exe) throws IOException, ServletException {
                    block7: {
                        ByteBuffer baos = new ByteBuffer();
                        try {
                            Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch(new String[]{DescriptorImpl.this.getHgExe(), "version"}, new String[0], (OutputStream)baos, null);
                            proc.join();
                            Matcher m = VERSION_STRING.matcher(baos.toString());
                            if (!m.find()) break block7;
                            try {
                                if (new VersionNumber(m.group(1)).compareTo(V0_9_4) >= 0) {
                                    this.ok();
                                } else {
                                    this.error("This hg is ver." + m.group(1) + " but we need 0.9.4+");
                                }
                            }
                            catch (IllegalArgumentException e) {
                                this.warning("Hudson can't tell if this hg is 0.9.4 or later (detected version is %s)", new Object[]{m.group(1)});
                            }
                            return;
                        }
                        catch (IOException e) {
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.error("Unable to check hg version");
                }
            }.process();
        }
    }
}

